

module "bs-prod" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-aws"
  eb_application_name = "${module.bs-app-production.beanstalk_application_name}"
  vpc_id = "vpc-bda8eed9"
  ec2_subnet_ids = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  elb_subnet_ids = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  elb_loadbalancer_security_groups = "sg-1825527e"
  auto_scaling_lc_security_groups = "sg-1825527e"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "availability-team@twitch.tv"
  service = "availability/goracle-catalog"
  env = "prod"
  associate_public_address = "false"
  cname_prefix = "goracle-catalog-prod"

}
