# Intro
scheduled job for goracle - notify managers of inactive primary owners

# CI
* [jenkins build job](https://jenkins.internal.justin.tv/job/availability-goracle-job-inactive-owners)
* [jenkins deploy job](https://jenkins.internal.justin.tv/job/availability-goracle-job-inactive-owners-lambda-deploy/)

# Build and deploy lambda manually
If jenkins jobs fails (eg AWS credential issues, etc)

# Build locally
* go build main.go

* get commit hash: `git rev-parse HEAD`
* build: `env GOOS=linux GOARCH=amd64 go build main.go`
* package: `zip -9r <commit-hash>.zip main`
* get AWS creds from [isengard](https://isengard.amazon.com/console-access) 
* publish: `aws s3 cp <commit-hash>.zip s3://availability-goracle-job-inactive-owners/<commit-hash>.zip`
* deploy the zip file:
   * [dev env (twitch-central-dev)](https://us-west-2.console.aws.amazon.com/lambda/home?region=us-west-2#/functions/inactive_owners-development?tab=graph)
   * [prod env (twitch-central-aws)](https://us-west-2.console.aws.amazon.com/lambda/home?region=us-west-2#/functions/inactive_owners-production?tab=graph)
 