job {
    name 'availability-goracle-job-inactive-owners'
    using 'TEMPLATE-autobuild'
    concurrentBuild true

    scm {
        git {
            remote {
                github 'availability/goracle-job-inactive-owners', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    wrappers {
        sshAgent 'git-aws-read-key'
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            file('AWS_UPLOADER_CONFIG_FILE', 'twitch-cape-qe-aws-profile')
        }
    }

    steps {
        shell './scripts/docker_build.sh'
        shell './scripts/docker_push.sh'
        saveDeployArtifact 'availability/goracle-job-inactive-owners', 'deploy'
        shell './scripts/publish_lambda.sh'
    }

    publishers {
        reportQuality('availability/goracle-job-inactive-owners', '.manta')
    }
}



job {
    name('availability-goracle-job-inactive-owners-lambda-deploy')
    using('TEMPLATE-lambda-deploy')
    scm {
        git {
            remote {
                github 'availability/goracle-job-inactive-owners', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    // TEMPLATE-lambda-deploy injects ENVIRONMENT and GIT_COMMIT parameters

    wrappers {
        sshAgent 'git-aws-read-key'
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'twitch-cape-qe-aws-profile')
            file('AWS_UPLOADER_CONFIG_FILE_DEV', 'twitch-central-web-availability')
            file('AWS_UPLOADER_CONFIG_FILE_PROD', 'twitch-central-aws-availability')
        }
    }

    steps {
        shell './scripts/deploy_lambda.sh'
    }
}
