#!/bin/bash

set -e
if [ "${ENVIRONMENT}" = "development" ]; then
  export AWS_SHARED_CREDENTIALS_FILE=$AWS_UPLOADER_CONFIG_FILE_DEV
  aws --profile tw_lambda_uploader s3 cp s3://availability-goracle-job-inactive-owners/$GIT_COMMIT.zip /tmp/$GIT_COMMIT.zip
  aws --profile tw_lambda_uploader lambda update-function-code --function-name inactive_owners-$ENVIRONMENT --publish --zip-file fileb:///tmp/$GIT_COMMIT.zip
  # if deploy to dev environment is successful, then publish build artifact to production s3 bucket
  export AWS_SHARED_CREDENTIALS_FILE=$AWS_UPLOADER_CONFIG_FILE_PROD
  aws s3 --profile tw_lambda_uploader cp /tmp/$GIT_COMMIT.zip s3://availability-goracle-job-inactive-owners-production/$GIT_COMMIT.zip
fi
if [ "${ENVIRONMENT}" = "production" ]; then
  export AWS_SHARED_CREDENTIALS_FILE=$AWS_UPLOADER_CONFIG_FILE_PROD
  aws --profile tw_lambda_uploader s3 cp s3://availability-goracle-job-inactive-owners-$ENVIRONMENT/$GIT_COMMIT.zip /tmp/$GIT_COMMIT.zip
  aws s3 --profile tw_lambda_uploader cp /tmp/$GIT_COMMIT.zip s3://availability-goracle-job-inactive-owners-production/$GIT_COMMIT.zip
  aws --profile tw_lambda_uploader lambda update-function-code --function-name inactive_owners-$ENVIRONMENT --publish --zip-file fileb:///tmp/$GIT_COMMIT.zip
fi