resource "aws_cloudwatch_metric_alarm" "invocation_error_alarm" {
  alarm_name = "${aws_lambda_function.tf_lambda_function.function_name}_lambda_invocation_alarm"
  comparison_operator = "GreaterThanThreshold"
  evaluation_periods = 1
  metric_name = "Errors"
  namespace = "AWS/Lambda"
  period = 60
  statistic = "Sum"
  threshold = 0
  dimensions {
    FunctionName = "${aws_lambda_function.tf_lambda_function.function_name}"
  }
}

// this transforms matching logs msgs into cloudwatch monitoring errors, which triggers the "invocation error alarm" above
resource "aws_cloudwatch_log_metric_filter" "log_error_metric" {
  name = "${aws_lambda_function.tf_lambda_function.function_name}_log_error"
  pattern = "ERROR"
  log_group_name = "/aws/lambda/${var.lambda_function_name}"

  metric_transformation {
    name = "Errors"
    namespace = "GoracleInactiveOwners"
    value = "1"
  }
}
