// Reference: https://github.com/datawire/tf-sns-pagerduty/blob/master/main.tf
resource "aws_sns_topic" "goracle_inactive_owners_pagerduty" {
  name = "goracle-inactive-owners-pagerduty"
  display_name = "goracle-inactive-owners-pagerdutyy"
}

resource "aws_sns_topic_subscription" "pagerduty" {
  // Reference: https://twitchoncall.pagerduty.com/services/P8C01Y9/integrations/PQU9VXY
  endpoint = "https://events.pagerduty.com/integration/0ca002d01dee49cfa2aee0df8e534f57/enqueue"
  endpoint_auto_confirms = true
  protocol = "https"
  topic_arn = "${aws_sns_topic.goracle_inactive_owners_pagerduty.arn}"
}