// Common variables and data go in here

variable "availability_aws_profile" {
  default = "twitch-central-aws"
}

variable "availability_aws_region" {
  default = "us-west-2"
}

variable "principal" {
  default = "arn:aws:iam::386434559102:root"
}


variable "repo" {
  default = "availability/goracle-job-inactive-owners"
}

variable "lambda_bucket" {
  default = "availability-goracle-job-inactive-owners-production"
}

variable "lambda_runtime" {
  default = "go1.x"
}

variable "lambda_function_name" {
  default = "inactive_owners-production"
}

variable "environment" {
  default = "production"
}

variable "slack_token" {
  // do not check in default value in here
}

variable "lambda_assume_role_policy" {
  default = <<EOF
{
    "Statement": [
        {
            "Action": "sts:AssumeRole",
            "Effect": "Allow",
            "Principal": {
              "Service": "lambda.amazonaws.com"
            }
        }
    ]
}
EOF

  description = "The assume role policy file to assign to this lambda function (Default: allows lambda function to assume roles)"
}

variable "external_uploader_account" {
  default     = "043714768218"
  description = "The AWS account ID of the external uploader user to allow to upload function updates to (used by jenkins uploader)"
}

variable "external_uploader_region" {
  default     = "us-west-2"
  description = "The AWS region of the external uploader user to allow to upload function updates to (used by jenkins uploader)"
}

variable "external_uploader_user" {
  default     = "tw_lambda_uploader"
  description = "The name of the external uploader user to allow to upload function updates to (used by jenkins uploader)"
}

