package catalog

import (
	"errors"
	"fmt"

	"github.com/jinzhu/gorm"
)

// Component contians the information that identifies a peice of infastructure
type Component struct {
	gorm.Model
	// Description  string
	Label       string `gorm:"not null;unique"`
	Claimed     bool
	Name        string
	Description string `gorm:"size:2000"`
	Type        string
	ServiceID   uint `gorm:"index:idx_component_service_id"`
	Service     *Service
	Rollup      bool // This is for rolling up into a service
	Metrics     []*Metric
	AccountID   uint
}

// URL returns the endpoint for the show page for a specific component
func (c *Component) URL() string {
	return "/components/" + fmt.Sprint(c.ID)
}

// BeforeSave is a gorm-invoked callback that is used for validation
func (c *Component) BeforeSave() error {
	if c.Label == "" {
		return errors.New("component label cannot be empty")
	}
	if c.Name == "" {
		return errors.New("component name cannot be empty")
	}
	if c.Type == "" {
		return errors.New("component type cannot be empty")
	}
	return nil
}

// DefaultComponent returns a zero component
func DefaultComponent() *Component {
	// Most of these wouldn't be different
	// if they were just excluded (zero values in Go),
	// but let's be explicit
	return &Component{
		Label:   getuuid(),
		Type:    "custom",
		Claimed: false,
	}
}
