package emailreport

import (
	"bytes"
	"fmt"
	"net/smtp"
	"strings"

	"github.com/sirupsen/logrus"
)

func SendMail(fromStr string, recipients []string, cc []string, subject string, msg string) {
	client, err := smtp.Dial("smtp.internal.justin.tv:25")
	if err != nil {
		logrus.Errorf("%s", err)
	}
	err = client.Mail("goracle-noreply@justin.tv")
	if err != nil {
		logrus.Errorf("%s", err)
	}

	hasCC := cc != nil
	allRecipients := make([]string, 0)

	for _, r := range recipients {
		allRecipients = append(allRecipients, r)
	}
	if hasCC {
		for _, r := range cc {
			allRecipients = append(allRecipients, r)
		}
	}
	for _, r := range allRecipients {
		err = client.Rcpt(r)
		if err != nil {
			logrus.Errorf("%s", err)
		}
	}

	toStr := strings.Join(recipients, ",")

	wc, err := client.Data()
	if err != nil {
		logrus.Errorf("%s", err)
	}

	defer func() {
		err = wc.Close()
		if err != nil {
			logrus.Errorf("%s", err)
		}
		logrus.Printf("Email sent")
	}()

	mime := "MIME-version: 1.0;\nContent-Type: text/html; charset=\"UTF-8\";\r\n\r\n"
	buf := bytes.NewBufferString(fmt.Sprintf("From: %s\r\nTo: %s\r\nSubject: %s\r\n%s%s", fromStr, toStr, subject, mime, msg))

	// handle CC list
	if hasCC  {
		ccStr := strings.Join(cc, ",")
		buf = bytes.NewBufferString(fmt.Sprintf("From: %s\r\nTo: %s\r\nCc: %s\r\nSubject: %s\r\n%s%s", fromStr, toStr, ccStr, subject, mime, msg))
	}

	fmt.Printf("email body=%s", buf.String())
	if _, err = buf.WriteTo(wc); err != nil {
		logrus.Errorf("%s", err)
	}
}
