# goracle

This is the repository for the new availability dashboard, which will eventually
run status.internal.justin.tv

Contact the #availability-team slack channels if you have questions!

FYI - we're using dep to vendor dependencies, if you add new dependencies use dep to update them.
See https://golang.github.io/dep/docs/daily-dep.html for instructions.
https://golang.github.io/dep/docs/Gopkg.toml.html for config file doc.

To get a dep graph, you can run
`dep status -dot|dot -T png -Grankdir=LR >dep.png`

## Config Management

**goracle** uses sandstorm to manage secrets. Everyone on the team-goracle LDAP group
can see our list of secrets.There are two ways secrets are accessed. One is through
the sandstorm.go code. The other is through the sandstorm template populated at EB time.

Useful commands for debugging this:
`/var/log/messages` Sandstorm agent will write any error messages to this file.
`/var/log/eb-activity.log` Any logs/errors encountered during eb setup will be here.
`/etc/sandstorm-agent/templates.d/goracle.conf` the template file to be rendered


## Running locally

**goracle** needs to run in UTC in order to function properly. For now, set the `TZ` environment variable when running:

    # one-time go get cmd to install bindata code generator
    go get -u github.com/jteeuwen/go-bindata/...
    go generate api/v2/schema.go
    TZ="UTC" go run cmd/goracle/goracle.go config.toml

**goracle** automatically redirects to https by default. In development, you will want to set the `require_https` flag in `config.toml` to false.

## Configure mysql for development

If using mysql for development to mirror production:

* `brew install mysql`
* Use `mysql.server start` to run the database (or have it always run on boot)
* Create a new user named `goracle`, with a password of your choice, and create the database
    * `mysql -u root`
    * `CREATE USER 'goracle'@'localhost' IDENTIFIED by 'goracle_password';`
    * GRANT ALL PRIVILEGES ON *.* TO 'goracle'@'localhost';
    * CREATE DATABASE catalogdb;
* create `config.toml` and add `catalogdb_password = "goracle_password"`

* configure the DSN as follows:

    `catalogdb_dsn="mysql://goracle:goracle_password@/catalogdb?charset=utf8&parseTime=True&loc=Local"`


## Adding AWS Accounts to `accounts` table (5/5/2017)

We are in the process of adding new AWS accounts to track more automatic / self-service / less sucky. In the meantime, accounts can be added by modifying the `scripts/create_accounts.py` to include the account you want to add in the dictionary. Then run `python scripts/create_accounts.py local` or `python scripts/create_accounts.py dev`, make sure the dev environment run worked, then run `python scripts/create_accounts.py prod`.

## Using SQLite for local dev

Simply use an entry like this in your config.toml:

    `catalogdb_dsn = "sqlite3://development.db"`

Or for in-memory:

    `catalogdb_dsn = "sqlite3://file::memory:?mode=memory&cache=shared"`

(The convoluted syntax rather than just :memory: is provided by
go-sqlite to ensure that all connections from the connection pool use
the same instance)

### Using the database seed

This repo comes with a SQL dump that can give you a ready-to-use goracle DB using SQLite. The repo's make file includes a `make db` target. It will blow away whatever exists in `development.db` and replace it with a clean DB sourced from `assets/db/dump.sqlite`.

## Compile times
go-sqlite needs to build SQLite itself which is a slow C compile. To
speed up your builds make sure to run `go build -i ./cmd/goracle` once
to install the .a archives and avoid this lengthy compilation on every
build.

## Running tests

If you want to run test coverage across the entire project, you can run this:

    `./scripts/coverage.sh --html`

It will run tests across all packages in the repo and open up an html coverage report.

For a quick, more human-readable test coverage check run:

    `go test -cover $(go list ./... | grep -v vendor)`



## Dumping a database (from staging)

* Set up sandstorm-CLI - https://wiki.twitch.com/display/SSE/Sandstorm+CLI

* Get the secrets for the endpoints and passwords using the role-arn

* Get the endpoint

    `sandstorm.osx get --role-arn arn:aws:iam::734326455073:role/sandstorm/production/templated/role/goracle-development goracle/development/catalogdb_endpoint`

* Get the password

    `sandstorm.osx get --role-arn arn:aws:iam::734326455073:role/sandstorm/production/templated/role/goracle-development goracle/development/catalogdb_password`

* Test your connection to the database

    `mysql -h aurora-cluster-goracle-dev.cluster-c0uxifsihoht.us-west-2.rds.amazonaws.com -u goracle -p`

* Dump the database to a file

    `mysqldump -h aurora-cluster-goracle-dev.cluster-c0uxifsihoht.us-west-2.rds.amazonaws.com -u goracle -p catalogdb > /tmp/dump.sql`

* A copy of staging db-dump taken on 06/15/18 is available [here] (https://git-aws.internal.justin.tv/availability/goracle/tree/master/assets/db/backup.sql.zip)

## AWS Elastic Beanstalk setup
Terraform does not setup the following:
* Healthcheck URL for the loadbalancer. THis should be set to /debug/running
* Email Notification for the environment

