package apiv2

import (
	"code.justin.tv/availability/goracle/goracleUser"
	"encoding/base64"
	"golang.org/x/oauth2"
	"code.justin.tv/availability/goracle/guardianauth"
	"github.com/pkg/errors"
	"github.com/neelance/graphql-go"
)

type goraclUserResolver struct {
	goracleUser *goracleUser.GoracleUser
}

func (r *Resolver) GoracleUser (
	args struct {
		AuthToken *string
	},
) (*goraclUserResolver, error) {
	if args.AuthToken != nil {
		// Validate the token and get the user represented by it
		// decode the AuthToken string that was encoded by the caller
		decodedAccessToken, err := base64.StdEncoding.DecodeString(*args.AuthToken)
		if err != nil {
			return nil, err
		}
		token := oauth2.Token{
			AccessToken: string(decodedAccessToken),
		}
		// next, get guardian user
		user, err := guardianauth.GuardianUserFromAuthToken(&token)
		if err != nil {
			return nil, err
		}

		goracleUserInstance, err := guardianauth.GoracleUserFromGuardianUser(user)
		if err != nil {
			return nil, err
		}

		return &goraclUserResolver{goracleUser: goracleUserInstance}, nil
	}
	return nil, errors.New("missing AuthToken parameter")
}


func (r *goraclUserResolver) UID() *string {
	if r.goracleUser != nil {
		return &r.goracleUser.UID
	}
	return nil
}

func (r *goraclUserResolver) CN() *string {
	if r.goracleUser != nil {
		return &r.goracleUser.CN
	}
	return nil
}
func (r *goraclUserResolver) EmployeeNumber() *graphql.ID{
	if r.goracleUser != nil {
		id := idUintToString(uint(r.goracleUser.EmployeeNumber))
		return &id
	}
	return nil
}
