//go:generate go-bindata -ignore=\.go -pkg=apiv2 -o=bindata.go ./...
package apiv2

import "bytes"

// Gets schema from the schema.graphql. This has to be done indirectly as the graphql module for golang doesn't
// provide a way to do this, so we do:
// 1) from schema.graphql schema definition file, generate bindata.go which implements functions to retrieve the data
// 2) GetSchema() calls generated functions in bindata.go and returns a string to the caller (golang graphql module)
func GetSchema() string {
	buf := bytes.Buffer{}
	for _, name := range AssetNames() {
		b := MustAsset(name)
		buf.Write(b)

		// Add a newline if the file does not end in a newline.
		if len(b) > 0 && b[len(b)-1] != '\n' {
			buf.WriteByte('\n')
		}
	}

	return buf.String()
}
