package apiv2

import (
	"fmt"
	"strconv"

	"code.justin.tv/availability/goracle/catalog"
    "code.justin.tv/qe/twitchldap"
	graphql "github.com/neelance/graphql-go"
)

func idUintToString(u uint) graphql.ID {
	return graphql.ID(strconv.FormatUint(uint64(u), 10))
}

func idStringToUint(s graphql.ID) (uint, error) {
	var u uint64
	var err error
	if u, err = strconv.ParseUint(string(s), 10, 32); err != nil {
		return 0, err
	}
	return uint(u), nil
}

func idsWithAttribute(typ string, attributeName, attributeValue *string) ([]uint, error) {
	if attributeName != nil || attributeValue != nil {
		params := make(map[string]interface{})
		// Add relevant filters
		if attributeName != nil {
			params["name"] = *attributeName
		}
		if attributeValue != nil {
			params["value"] = *attributeValue
		}
		params["object_type"] = typ
		attrs, err := catalog.GetCatalog().GetAttributes(params)
		if err != nil {
			return nil, err
		}
		ids := []uint{}
		for _, attr := range attrs {
			ids = append(ids, attr.ObjectId)
		}
		return ids, nil
	}
	return nil, nil
}

// Lookup a user and make sure they are real.
// Returns the employeeNumber of the user as a uint,
// or an error
func validatePrimaryOwnerID(id graphql.ID) (uint, error) {
	employeeNumber, err := idStringToUint(id)
	if err != nil {
		return 0, err
	}
    c, err := twitchldap.NewClient()
	defer c.Close()
	if err != nil {
		return 0, err
	}
	info, err := c.GetUserInfo(uint32(employeeNumber))
	if err != nil {
		return 0, err
	}
	if info == nil {
		return 0, fmt.Errorf("user with id '%s' was not found in LDAP", string(id))
	}
	return employeeNumber, nil
}

func safeString(s *string) string {
	if s == nil {
		return "<nil>"
	}
	return *s
}