package catalog

// Catalog interface defines the set of functions that can be used to interface with any service catalog implementation
type Catalog interface {
	GetComponentByID(uint) (*Component, error)
	GetServiceByID(uint) (*Service, error)
	GetFeatureByID(uint) (*Feature, error)
	GetMetricByID(uint) (*Metric, error)
	GetQueryByID(uint) (*Query, error)
	GetServiceTypeByID(uint) (*ServiceType, error)
	GetAttributeByID(uint) (*Attribute, error)
	GetServiceDependencyByID(uint) (*ServiceDependency, error)

	GetComponents(map[string]interface{}) ([]*Component, error)
	GetServices(map[string][]interface{}) ([]*Service, error)
	GetServiceTypes() ([]*ServiceType, error)
	GetStates() ([]*State, error)

	GetFeatures() ([]*Feature, error)
	GetMetrics(map[string]interface{}) []*Metric
	GetQueries(map[string]interface{}) []*Query
	GetServiceAudits(map[string]interface{}) []*ServiceAudit
	GetLatestServiceAudits(map[string]interface{}) []*ServiceAudit
	GetLogRecords(map[string]interface{}, int, int) []*LogRecord
	GetAttributes(map[string]interface{}) ([]*Attribute, error)
	GetServiceDependencies(map[string]interface{}) ([]*ServiceDependency, error)

	GetServiceAuditTypes() []string

	AddComponent(*Component) error
	AddService(*Service) error
	AddServiceType(*ServiceType) error
	AddMetric(*Metric) error
	AddQuery(*Query) error
	AddServiceAudit(*ServiceAudit) error
	AddLogRecord(*LogRecord) error
	AddAttribute(*Attribute) error
	AddServiceDependency(*ServiceDependency) error

	DeleteComponent(*Component) error
	DeleteService(*Service) error
	DeleteMetric(*Metric) error
	DeleteQuery(*Query) error
	DeleteAttribute(*Attribute) error
	DeleteServiceDependency(*ServiceDependency) error

	GetRootFeatures() []*Feature
	UnknownComponents() []*Component

	GetComponentsByIDs([]uint) ([]*Component, error)
	GetServicesByIDs([]uint) ([]*Service, error)
	GetFeaturesByIDs([]uint) ([]*Feature, error)
	GetMetricsByIDs([]uint) ([]*Metric, error)
	GetQueriesByIDs([]uint) ([]*Query, error)
	GetAttributesByIDs([]uint) ([]*Attribute, error)
	GetServiceDependenciesByIDs([]uint) ([]*ServiceDependency, error)

	GetComponentsComplete([]uint, map[string]interface{}) ([]*Component, error)
	GetServicesComplete([]uint, map[string][]interface{}) ([]*Service, error)
	GetFeaturesComplete([]uint, map[string]interface{}) ([]*Feature, error)
	GetMetricsComplete([]uint, map[string]interface{}) ([]*Metric, error)
	GetQueriesComplete([]uint, map[string]interface{}) ([]*Query, error)
	GetAttributesComplete([]uint, map[string]interface{}) ([]*Attribute, error)
	GetServiceDependenciesComplete([]uint, map[string]interface{}) ([]*ServiceDependency, error)
}

// GetCatalog returns the corect implemtation of the catalog interface for use
func GetCatalog() Catalog {
	return getDBCatalog()
}
