package catalog

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

type teststruct struct {
	Foo string
	Bar int
}

func TestLogRecord(t *testing.T) {
	l := &LogRecord{}
	b := teststruct{"monkey", 123}
	a := teststruct{"monkey2", 12345}
	l.WithBefore(b).WithAfter(a)
	assert.JSONEq(t, `{"Foo":"monkey", "Bar":123}`, l.Before, "Before field doesn't match")
	assert.JSONEq(t, `{"Foo":"monkey2", "Bar":12345}`, l.After, "After field doesn't match")
}
