package main

import (
	"code.justin.tv/availability/goracle/externalclient"
	"fmt"
	"github.com/sirupsen/logrus"

	"bufio"
	"github.com/howeyc/gopass"
	"os"
	"strings"
)

func main() {
	reader := bufio.NewReader(os.Stdin)
	fmt.Print("Username: ")
	user, err := reader.ReadString('\n')
	fmt.Print("Password: ")
	pass, err := gopass.GetPasswdMasked()
	if err != nil {
		fmt.Println(err.Error())
	}
	fmt.Println("Making a request to create service over guardian api")
	cfg := externalclient.GQLClientConfig{
		Endpoint: "https://status.internal.justin.tv/api/v2/query.guardian",
		Username: strings.TrimSpace(string(user)),
		Password: strings.TrimSpace(string(pass)),
	}
	logrus.SetLevel(logrus.DebugLevel)
	client := externalclient.NewGqlClient(cfg, logrus.StandardLogger())
	newService := externalclient.ServiceInput{
		"TestAPIService",
		"This service was created from a script through the guardian endpoint",
		"4",
		strings.TrimSpace(string(user)),
		"internal-ops",
		"",
		"C03C7TR5L",
		[]*externalclient.ServiceAttribute{{"tier", "2"}},
		nil,
		nil,
	}
	result, err := client.CreateService(&newService)
	if err != nil {
		fmt.Println("failure in requesting service ", err)
		return
	}
	fmt.Println("Successful creation of service made to service catalog guardian endpoint", cfg.Endpoint)
	fmt.Printf("The following service was created %v", result)
}

