package main

import (
    "code.justin.tv/availability/goracle/externalclient"
    "fmt"
    "github.com/sirupsen/logrus"

    "bufio"
    "github.com/howeyc/gopass"
    "os"
    "strings"
)

func main() {
    reader := bufio.NewReader(os.Stdin)
    fmt.Print("Username: ")
    user, err := reader.ReadString('\n')
    fmt.Print("Password: ")
    pass, err := gopass.GetPasswdMasked()
    if err != nil {
        fmt.Println(err.Error())
    }
    fmt.Println("Making a request to get a list of all services from guardian api")
    cfg := externalclient.GQLClientConfig{
        Endpoint: "https://status.internal.justin.tv/api/v2/query.guardian",
        Username: strings.TrimSpace(string(user)),
        Password: strings.TrimSpace(string(pass)),
    }
    logrus.SetLevel(logrus.DebugLevel)
    client := externalclient.NewGqlClient(cfg, logrus.StandardLogger())
    result, err := client.SimpleGetServices()
    if err != nil {
        fmt.Println("failure in requesting service ", err)
        return
    }
    fmt.Println("Successful Query made to service catalog guardian endpoint")
    fmt.Printf("Services in service catalog %s", result)
}
