package main

import (
	"fmt"
	"os"

	"code.justin.tv/qe/twitchldap"
)

// ldapdump is a simple top-to-bottom validation against
// being able to query LDAP for users via the catalog as
// an in-between layer

func main() {
	fmt.Println("Fetching Users from catalog")
	fmt.Println("")
	c, err := twitchldap.NewClient()
	defer c.Close()
	if err != nil {
		fmt.Printf("ERROR: %s\n", err.Error())
	}
	users, err := c.GetAllUserInfo()
	if err != nil {
		fmt.Printf("ERROR: %s\n", err.Error())
		os.Exit(1)
	}
	for _, user := range users {
		fmt.Printf("Found user: %s\n", user.CN)
		fmt.Printf("	CN: %s\n", user.CN)
		fmt.Printf("	UID: %s\n", user.UID)
		fmt.Printf("	AmzUID: %s\n", user.TwitchAmznUID)
		fmt.Printf("	EmployeeNumber: %d\n", user.EmployeeNumber)
	}
}
