package main

import (
	"bytes"
	"encoding/json"
	"fmt"
	"net/http"
)

func jsonreq(method, url string, v, r interface{}) error {
	b := new(bytes.Buffer)
	if v != nil {
		err := json.NewEncoder(b).Encode(v)
		if err != nil {
			return err
		}
	}
	client := &http.Client{}
	req, err := http.NewRequest(method, url, b)
	if err != nil {
		return err
	}
	req.Header.Set("Content-Type", "application/json; charset=utf-8")
	resp, err := client.Do(req)
	if err != nil {
		return err
	}
	if resp.StatusCode != 200 && resp.StatusCode != 201 {
		return fmt.Errorf("Status not OK: %d", resp.StatusCode)
	}
	dec := json.NewDecoder(resp.Body)
	err = dec.Decode(r)
	if err != nil {
		return err
	}
	return nil
}

func putjson(url string, v, r interface{}) error {
	return jsonreq("PUT", url, v, r)
}

func postjson(url string, v, r interface{}) error {
	return jsonreq("POST", url, v, r)
}

func getjson(url string, r interface{}) error {
	return jsonreq("GET", url, nil, r)
}
