package main

import (
	"flag"
	"fmt"
	"log"
	"regexp"

	"code.justin.tv/availability/goracle/statusserver/cataloghandlers"
)

var apiurl = "http://localhost:8000/api/v1"
var match, from, to string
var dry = true
var debug = false

var latencyPercentiles = []int{50, 90, 99}

func debugf(format string, v ...interface{}) {
	if debug {
		log.Printf(format, v...)
	}
}

func main() {
	flag.StringVar(&apiurl, "api", apiurl, "Base URL of the goracle catalog API")
	flag.StringVar(&match, "match", match, "apply edit to queries matching this pattern")
	flag.StringVar(&from, "from", from, "from regexp")
	flag.StringVar(&to, "to", to, "to string")
	flag.BoolVar(&dry, "dry", dry, "Dry run")
	flag.BoolVar(&dry, "n", dry, "Dry run")
	flag.BoolVar(&debug, "debug", debug, "Enable debug output")
	flag.BoolVar(&debug, "d", debug, "Enable debug output")
	flag.Parse()

	if match == "" || from == "" || to == "" {
		log.Fatal("-match, -from and -to are required")
	}
	match_re := regexp.MustCompile(match)
	from_re := regexp.MustCompile(from)

	var queries []cataloghandlers.Query
	url := apiurl + "/queries/"
	err := getjson(url, &queries)
	if err != nil {
		log.Fatal(err)
	}
	for _, q := range queries {
		if q.ID == nil {
			debugf("got nil ID")
			continue
		}
		if q.Query == nil {
			debugf("nil Query field for %d", *q.ID)
			continue
		}
		if !match_re.MatchString(*q.Query) {
			continue
		}
		new := from_re.ReplaceAllString(*q.Query, to)
		fmt.Printf("%d: %s => %s\n", *q.ID, *q.Query, new)
		if dry {
			debugf("dry run, not updating %d", *q.ID)
			continue
		}
		q.Query = &new
		puturl := fmt.Sprintf("%s/queries/%d", apiurl, *q.ID)
		fmt.Println(puturl)
		err := putjson(puturl, &q, &q)
		if err != nil {
			log.Fatal(err)
		}

	}

}
