package main

import (
	"fmt"

	"github.com/sirupsen/logrus"

	"bytes"
	"code.justin.tv/sse/malachai/pkg/s2s/caller"
	"encoding/json"
	"io/ioutil"
	"net/http"
	"bufio"
	"os"
	"strings"
)

// s2sCall validates that you have s2s set up correctly.
// See README for setup

func main() {
	reader := bufio.NewReader(os.Stdin)
	fmt.Print("Username: ")
	user, err := reader.ReadString('\n')
	user = strings.Trim(user, "\n")

	fmt.Println("Making a request to get a service from s2s api")
	var cfg *caller.Config
	logger := logrus.New()

	t, err := caller.NewRoundTripper("service-catalog-dev", cfg, logger)
	if err != nil {
		logger.Error(err)
		return
	}

	client := http.Client{
		Transport: t,
	}
	type GraphqlQuery struct {
		Operation string                  `json:"operationName"`
		Query     string                  `json:"query"`
		Variables *map[string]interface{} `json:"variables"`
	}
	testQuery := GraphqlQuery{
		Query: `{service(id: "1") {id, name, pagerduty, slack, team_id}}`,
	}
	exampleQuery, err := json.Marshal(testQuery)
	if err != nil {
		logger.Error("Could not parse given json")
	}

	request, err := http.NewRequest("POST", "http://localhost:8000/api/v2/query.s2s", bytes.NewBufferString(string(exampleQuery)))
	if err != nil {
		logger.Error(err)
		return
	}
	request.Header.Set("Content-Type", "application/json")
	request.Header.Set("authUser", user)
	res, err := client.Do(request)
	if err != nil {
		logger.Error(err)
		return
	}
	logger.Infof("http status: %s", res.Status)
	bodyBytes, err := ioutil.ReadAll(res.Body)
	logger.Infof("http Body: %s", string(bodyBytes))
	t.Close()
}
