package emailreport

type jsonGenerators []jsonGeneratorData

type jsonGeneratorData struct {
	ID          string
	Name        string
	Description string
	Subject     string
	Recipients  []string
	DataSource  string
}

type jsonGenerator struct {
	id          string
	name        string
	description string
	subject     string
	recipients  []string
	dataSource  DataSource
}

type DataSource interface {
	Data() interface{}
}

func NewJSONGenerator(data jsonGeneratorData) Generator {
	var dataSource DataSource
	switch data.DataSource {
	case "availability":
		dataSource = NewAvailabilityDataSource()
	default:
		dataSource = nil
	}
	return &jsonGenerator{
		id:          data.ID,
		name:        data.Name,
		description: data.Description,
		subject:     data.Subject,
		recipients:  data.Recipients,
		dataSource:  dataSource,
	}
}

func (jg *jsonGenerator) ID() string {
	return jg.id
}

func (jg *jsonGenerator) Name() string {
	return jg.name
}

func (jg *jsonGenerator) Description() string {
	return jg.description
}

func (jg *jsonGenerator) Subject() string {
	// FIXME: Do template substitution for variables
	return jg.subject
}

func (jg *jsonGenerator) Recipients() []string {
	return jg.recipients
}

func (jg *jsonGenerator) ReportTime() string {
	return "02:45"
}

func (jg *jsonGenerator) Data() interface{} {
	return jg.dataSource.Data()
}
