package emailreport

import (
	"encoding/json"
	"io/ioutil"

	"github.com/sirupsen/logrus"

	"code.justin.tv/availability/goracle/config"
)

// Manager tracks all of the report generators
type Manager struct {
	generators map[string]Generator
}

var manager *Manager

// GetManager returns the singleton of the email report manager and
// initializes it if it hasn't been initialized yet
func GetManager() *Manager {
	if manager == nil {
		initManager()
	}
	return manager
}

// Generators returns a list of all email reporters
func (m *Manager) Generators() map[string]Generator {
	return m.generators
}

func initManager() {
	newManager := Manager{
		generators: map[string]Generator{},
	}

	// Load generators from JSON
	bytes, _ := ioutil.ReadFile(config.StaticConfigPath("emailgenerators.json"))
	generatorData := jsonGenerators{}
	err := json.Unmarshal(bytes, &generatorData)
	if err != nil {
		logrus.Fatal("Error unmarshaling JSON:", err.Error())
	}

	for _, gData := range generatorData {
		// FIXME: Check for name collisions
		g := NewJSONGenerator(gData)
		newManager.generators[g.ID()] = g
	}

	manager = &newManager
}

// // RunMailCron spins up gocron to run the mailer daily
// func RunMailCron() {
// 	gocron.Every(1).Day().At("02:45").Do(RunEmailReports)
// }

// // RunEmailReports actually does the work to send email reports
// func RunEmailReports() {
// 	for _, reporter := range GetManager().emailReporters {
// 		runReporter(reporter)
// 	}
// }
