job {
    name 'availability-goracle'
    using 'TEMPLATE-autobuild'
    concurrentBuild true

    scm {
        git {
            remote {
                github 'availability/goracle', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    wrappers {
        sshAgent 'git-aws-read-key'
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
        }
        environmentVariables {
          env('GIT_BRANCH', '${GIT_BRANCH}')
          env('GIT_COMMIT', '${GIT_COMMIT}')
          env('GIT_URL', '${GIT_URL}')
        }
    }

    steps {
        shell './scripts/build.sh'
        shell './scripts/push.sh'
        saveDeployArtifact 'availability/goracle-ebextensions', 'deploy/'
    }

    publishers {
  		reportQuality('availability/goracle', '.manta', '*.txt')
    }
}

freeStyleJob('availability-goracle-production-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-central-aws-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-central-aws-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'availability/goracle-ebextensions'
        shell 'rm -f *.manifest*'
        shell 'cp -r config/production/. .ebextensions/'
        // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-goracle:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | set -e
                | eb deploy production-availability-goracle-env
                | eb deploy svc-prod-goracle-ext-b""".stripMargin()
    }
}

freeStyleJob('availability-goracle-development-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-central-dev-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-central-dev-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'availability/goracle-ebextensions'
        shell 'rm -f *.manifest*'
        shell 'cp -r config/development/. .ebextensions/'
       // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-goracle:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | set -e
                | eb deploy development-availability-goracle-env --timeout 20
                | eb deploy svc-dev-goracle-ext --timeout 20""".stripMargin()
    }
}

freeStyleJob('availability-goracle-development-noproxy-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-central-dev-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-central-dev-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'availability/goracle-ebextensions'
        shell 'rm -f *.manifest*'
        // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-goracle:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | set -e
                | eb deploy goracle-bs-development-int-env
                | eb deploy goracle-bs-development-ext-env""".stripMargin()
    }

    publishers {
        downstreamParameterized{
            trigger('availability-goracle-development-noproxy-post-deploy') {
                condition('SUCCESS')
                triggerWithNoParameters(true)
            }
        }
    }
}

freeStyleJob('availability-goracle-production-noproxy-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-central-aws-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-central-aws-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'availability/goracle-ebextensions'
        shell 'rm -f *.manifest*'
        // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/availability-goracle:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/var/app",
                |      "HostDirectory": "/var/app"
                |    },
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | set -e
                | eb deploy goracle-bs-production-int-env
                | eb deploy goracle-bs-production-ext-env""".stripMargin()
    }
    publishers {
        downstreamParameterized{
            trigger('availability-goracle-production-noproxy-post-deploy') {
                condition('SUCCESS')
                triggerWithNoParameters(true)
            }
        }
    }
}

freeStyleJob('availability-goracle-development-noproxy-post-deploy') {
    scm {
        git {
            remote {
                github 'availability/goracle', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        shell 'echo "export URL=https://servicecatalog-api-dev.internal.justin.tv" > URL'
        shell "rm -rf .manta && mkdir -p .manta"
        shell 'manta -v -f validate.json'
    }
}

freeStyleJob('availability-goracle-production-noproxy-post-deploy') {
    scm {
        git {
            remote {
                github 'availability/goracle', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        shell 'echo "export URL=https://servicecatalog-api.internal.justin.tv" > URL'
        shell "rm -rf .manta && mkdir -p .manta"
        shell 'manta -v -f validate.json'
    }
}
