#!/bin/bash -e
if [ -z "$goracle_dev_endpoint" ];
then echo "Set environment variable goracle_dev_endpoint before continuing."; exit;
else echo "Using goracle_dev_endpoint = $goracle_dev_endpoint"; fi

if [ -z "$goracle_prod_endpoint" ];
then echo "Set environment variable goracle_prod_endpoint before continuing."; exit;
else echo "Using goracle_prod_endpoint = $goracle_prod_endpoint"; fi

echo "Enter Goracle Production Password"
mysqldump -h $goracle_prod_endpoint \
    -u goracle \
    -p \
    --port=3306 \
    --single-transaction \
    --databases catalogdb \
    --add-drop-table \
    > goracle.sql

echo "Enter Goracle Development Password"
mysql -h $goracle_dev_endpoint -u goracle -p --port 3306 < goracle.sql
echo "Goracle Production DB to Development DB copy complete."
