import requests
import json
import sys
    
# This script will update the accounts in the service catalog database.
# It was written as a temporary solution to establish associations between
# components and their AWS Accounts until a more streamlined solution is
# put into place.

if len(sys.argv) < 2:
    print("Must provide an environment to run the script against, either `prod`, `dev`, or `local`")
    sys.exit(1)
elif sys.argv[1] == "prod":
    accounts_url = "http://status.internal.justin.tv/api/v1/accounts"
elif sys.argv[1] == "dev":
    accounts_url = "http://status-development.internal.justin.tv/api/v1/accounts"
elif sys.argv[1] == "local":
    accounts_url = "http://127.0.0.1:8000/api/v1/accounts"
else:
    print("Invalid environment specified: {env}".format(env=sys.argv[1]))
    sys.exit(1)

# Fields needed: 
# - alias
# - aws_account_id
# - description
accounts = {
    "603200399373": "twitch-chat-aws",
    "523543649671": "twitch-gds-aws",
    "433397531694": "twitch-ads-aws",
    "641044725657": "twitch-web-aws",
    "052331484169": "twitch-passport",
    "868653755646": "twitch-it-aws",
    "425992774280": "twitch-cape-qe-aws",
    "848744099708": "twitch-video-aws",
    "777516492425": "twitch-engagement-aws",
    "177642657845": "twitch-playlists-aws",
    "673337243802": "twitch-rlec-aws",
    "924637445623": "twitch-discovery-aws",
    "854594403332": "twitch-sse-prod",
    "007917851548": "twitch-central-aws",
    "233055323480": "twitch-cape-capacitymanagement-aws",
    "914569885343": "twitch-feed-aws",
    "021561903526": "twitch-bits-aws",
    "134912696936": "twitch-vinyl-aws",
    "277437172290": "twitch-video-ops-aws",
    "316550374861": "twitch-revenue-aws",
    "501319536573": "twitch-gns-aws",
    "508423404353": "twitch-security-aws",
    "654663525958": "twitch-community-moderation-aws",
    "727894822935": "twitch-creative-aws",
    "734326455073": "twitch-systems-aws",
    "958416494912": "twitch-history-aws",
    "277306168768": "twitchstore-aws-prod"
}

for acct_id in accounts:
    alias = accounts[acct_id]
    description = "AWS Account with account number {acct_id} and alias {alias}".format(
        acct_id=acct_id,
        alias=alias
    )
    api_struct = {
        "aws_account_id": acct_id,
        "alias": alias,
        "description": description
    }
    # Check if the account exists already
    # if it does, update the fields 
    resp = requests.get(accounts_url + "?alias=" + alias)
    if resp.status_code == 200 and len(resp.json()) > 0:
        catalog_id = resp.json()[0]['id']
        if acct_id != resp.json()[0]['aws_account_id']:
            print("fixing account: " + alias)
            requests.put(accounts_url + "/" + str(catalog_id), data=json.dumps(api_struct))
        continue
    else:
        print(json.dumps(api_struct))
        resp = requests.post(accounts_url, data=json.dumps(api_struct))
        if resp.status_code != 201 and resp.status_code != 200:
            # 422 is the expected non-201 case
            # it just means that the component already exists,
            # so we should just skip over all the junk to create
            if resp.status_code != 422:
                print(resp.text)
                errors[data['component']['name']] = resp.json()['errors']
            else:
                print("Account already exists!")
    
    
