package serverutil

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

// Tests for stringToUint

func TestStringToUint(t *testing.T) {
	id, err := StringToUint("12")
	assert.NoError(t, err, "there should be no error")
	assert.Equal(t, uint(12), id, "the id should be 12")

	id, err = StringToUint("a")
	assert.Error(t, err, "there should be an error")
	assert.Equal(t, uint(0), id, "the id should be 0")
}
