package stats

import (
	"os"
	"testing"

	"github.com/cactus/go-statsd-client/statsd"
	"github.com/stretchr/testify/assert"
	"code.justin.tv/availability/goracle/config"
	"code.justin.tv/commerce/splatter"
)

func TestClientInit(t *testing.T) {
	DisableStats()
	switch StatsdClient().(type) {
	case *statsd.NoopClient:
		return
	default:
		assert.Fail(t, "basic stats init should create a noop client")
	}
}

func TestEnableStats(t *testing.T) {
	// Enabling stats should turn the statsd client
	// into a buffered sender
	_ = os.Setenv("ENVIRONMENT", "testing")
	config.SetDefaultConfig()
	err := EnableStats(&config.Config)
	assert.Nil(t, err)
	client := StatsdClient()
	switch client.(type) {
	case *splatter.TwitchTelemetryStatter:
		return
	default:
		assert.Fail(t, "statsd client should be a buffered client after enabling")
	}
}

func TestEnableStatsWithoutEnvironment(t *testing.T) {
	os.Setenv("ENVIRONMENT", "")
	config.SetDefaultConfig()
	err := EnableStats(&config.Config)
	assert.NotNil(t, err)
}
