package stats

import (
	"context"
	"testing"

	"github.com/neelance/graphql-go/errors"
	"github.com/neelance/graphql-go/introspection"
	"github.com/stretchr/testify/assert"
)

func TestTracer(t *testing.T) {
	ctx := context.Background()
	mockOutStatter()
	mockedStatter := StatsdClient().(*mockStatter)

	tracer := &Tracer{}

	// do some testing with a valid query
	newCtx, callbackFunc := tracer.TraceQuery(ctx, "{foobars{}}", "foobars", make(map[string]interface{}), make(map[string]*introspection.Type))
	// callback contains no errors
	callbackFunc([]*errors.QueryError{})
	assert.Equal(t, 1, mockedStatter.NumCounterCalls("api.queries.foobars.success"))
	assert.Equal(t, 1, mockedStatter.NumTimerCalls("api.queries.foobars.success"))
	// no failure stats recorded
	assert.Equal(t, 0, mockedStatter.NumCounterCalls("api.queries.foobars.failure"))
	assert.Equal(t, 0, mockedStatter.NumTimerCalls("api.queries.foobars.failure"))
	// total gets incremented
	assert.Equal(t, 1, mockedStatter.NumTimerCalls("api.queries.foobars.total"))

	// callback contains errors
	callbackFunc([]*errors.QueryError{&errors.QueryError{}})
	// didnt change the success hits
	assert.Equal(t, 1, mockedStatter.NumCounterCalls("api.queries.foobars.success"))
	assert.Equal(t, 1, mockedStatter.NumTimerCalls("api.queries.foobars.success"))
	// now we have errors logged
	assert.Equal(t, 1, mockedStatter.NumCounterCalls("api.queries.foobars.failure"))
	assert.Equal(t, 1, mockedStatter.NumTimerCalls("api.queries.foobars.failure"))
	// 2 requests recorded total
	assert.Equal(t, 2, mockedStatter.NumTimerCalls("api.queries.foobars.total"))

	// ensure the context didnt change... it just gets passed through
	assert.Equal(t, ctx, newCtx)

	// do it all again with a mutation query
	newCtx, callbackFunc = tracer.TraceQuery(ctx, "mutation Wubbaflubdub { foobars{} }", "Wubbaflubdub", make(map[string]interface{}), make(map[string]*introspection.Type))
	// callback contains no errors
	callbackFunc([]*errors.QueryError{})
	assert.Equal(t, 1, mockedStatter.NumCounterCalls("api.mutations.Wubbaflubdub.success"))
	assert.Equal(t, 1, mockedStatter.NumTimerCalls("api.mutations.Wubbaflubdub.success"))
	// no failure stats recorded
	assert.Equal(t, 0, mockedStatter.NumCounterCalls("api.mutations.Wubbaflubdub.failure"))
	assert.Equal(t, 0, mockedStatter.NumTimerCalls("api.mutations.Wubbaflubdub.failure"))
	// total gets incremented
	assert.Equal(t, 1, mockedStatter.NumTimerCalls("api.mutations.Wubbaflubdub.total"))

	// callback contains errors
	callbackFunc([]*errors.QueryError{&errors.QueryError{}})
	// didnt change the success hits
	assert.Equal(t, 1, mockedStatter.NumCounterCalls("api.mutations.Wubbaflubdub.success"))
	assert.Equal(t, 1, mockedStatter.NumTimerCalls("api.mutations.Wubbaflubdub.success"))
	// now we have errors logged
	assert.Equal(t, 1, mockedStatter.NumCounterCalls("api.mutations.Wubbaflubdub.failure"))
	assert.Equal(t, 1, mockedStatter.NumTimerCalls("api.mutations.Wubbaflubdub.failure"))
	// 2 requests recorded total
	assert.Equal(t, 2, mockedStatter.NumTimerCalls("api.mutations.Wubbaflubdub.total"))

	// ensure the context didnt change... it just gets passed through
	assert.Equal(t, ctx, newCtx)
}
