package confighandlers

import (
	"encoding/json"
	"net/http"

	"code.justin.tv/availability/goracle/config"
	"code.justin.tv/availability/goracle/serverutil"
	"github.com/rs/cors"
	goji "goji.io"
	"goji.io/pat"
)

func returnString(s string) func(w http.ResponseWriter, r *http.Request) {
	temp := func(w http.ResponseWriter, r *http.Request) {
		returnJSON, err := json.Marshal(s)
		if err != nil {
			serverutil.HandleAPIErrors(w, []error{err}, 500)
			return
		}
		w.Header().Set("Content-Type", "application/json; charset=UTF-8")

		w.WriteHeader(http.StatusOK)
		w.Write(returnJSON)
	}
	return temp
}

func RegisterHandlers(mux *goji.Mux) {
	c := cors.New(cors.Options{
		AllowedOrigins: []string{"*"},
	})

	con := goji.SubMux()
	con.Use(c.Handler)
	mux.Handle(pat.New("/config/v1/*"), con)

	con.HandleFunc(pat.Get("/hms-esk-endpoint/"), returnString(config.HMSEskEndpoint()))
}
