

module "goracle-bs-development-int" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-dev"
  eb_application_name = "${module.bs-app-development.beanstalk_application_name}"
  vpc_id = "vpc-a19ca9c5"
  ec2_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  elb_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  elb_loadbalancer_security_groups = "sg-e55f4f83"
  auto_scaling_lc_security_groups = "sg-e55f4f83"
  auto_scaling_lc_iam_instance_profile = "${aws_iam_role.bs.id}"
  elb_loadbalancer_ssl_cert = "arn:aws:acm:us-west-2:386434559102:certificate/588bde5e-2054-47ad-afe5-82e4b4ab656d"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.2 running Docker 18.03.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "oe-tools@justin.tv"
  service = "availability/goracle"
  env = "development"
  associate_public_address = "false"
  cname_prefix = "servicecatalog-goracle-dev-int"
  common_name = "servicecatalog-goracle-dev-int"
  enable_v1_api = "true"
}

module "goracle-bs-development-ext" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-dev"
  eb_application_name = "${module.bs-app-development.beanstalk_application_name}"
  vpc_id = "vpc-a19ca9c5"
  ec2_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  elb_subnet_ids = "subnet-041c4760,subnet-47e99931,subnet-3f41f267"
  elb_loadbalancer_security_groups = "sg-0f277a34084fecdda"
  auto_scaling_lc_security_groups = "sg-e55f4f83"
  elb_loadbalancer_ssl_cert = "arn:aws:acm:us-west-2:386434559102:certificate/588bde5e-2054-47ad-afe5-82e4b4ab656d"
  auto_scaling_lc_iam_instance_profile = "${aws_iam_role.bs.id}"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.2 running Docker 18.03.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "oe-tools@justin.tv"
  service = "availability/goracle"
  env = "development"
  associate_public_address = "false"
  cname_prefix = "servicecatalog-goracle-dev-ext"
  common_name = "servicecatalog-goracle-dev-ext"
  elb_scheme = "public"
}
