variable "iam_instance_profile" {
  description = "IAM Instance Profile for the Beanstalk"
  default = "servicecatalog-goracle-development"
}

resource "aws_iam_role" "bs" {
  name = "${var.iam_instance_profile}"
  path = "/"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": { "Service": "ec2.amazonaws.com"},
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "bs" {
  name   = "${var.iam_instance_profile}"
  role   = "${aws_iam_role.bs.id}"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "BucketAccess",
      "Action": [
        "s3:Get*",
        "s3:List*",
        "s3:PutObject"
      ],
      "Effect": "Allow",
      "Resource": [
        "arn:aws:s3:::elasticbeanstalk-*",
        "arn:aws:s3:::elasticbeanstalk-*/*"
      ]
    },
    {
      "Action": [
        "logs:CreateLogStream",
        "logs:DescribeLogStreams",
        "logs:CreateLogGroup",
        "logs:PutLogEvents"
        ],
      "Effect": "Allow",
      "Resource": ["*"]
    },
    {
        "Sid": "FultonContactServiceAccess",
        "Effect": "Allow",
        "Action": "lambda:InvokeFunction",
        "Resource": "arn:aws:lambda:us-west-2:117703951204:function:MyFultonContactsServiceLambda-LambdaFunction-1FXZU65CZ6XXT"
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "bs" {
  depends_on = ["aws_iam_role.bs"]
  name       = "${var.iam_instance_profile}"
  role       = "${aws_iam_role.bs.name}"
}

resource "aws_iam_role_policy_attachment" "attach-old-email-ses-perms" {
    policy_arn = "arn:aws:iam::aws:policy/AmazonSESFullAccess"
    role       = "${aws_iam_role.bs.name}"
}


resource "aws_iam_policy" "policy-s2s" {
  name        = "servicecatalog_goracle_s2s_dev_policy"
  path        = "/"
  description = "Development policy for enabling s2s access"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": {
        "Effect": "Allow",
        "Action": "sts:AssumeRole",
        "Resource": "arn:aws:iam::180116294062:role/malachai/*"
    }
}EOF
}

resource "aws_iam_role_policy_attachment" "attach-dev-goracle-s2s" {
    role        = "${aws_iam_role.bs.name}"
    policy_arn  = "${aws_iam_policy.policy-s2s.arn}"
}

resource "aws_iam_role_policy" "servicecatalog_goracle_sandstorm_dev_policy" {
  name = "sandstorm-development-goracle-team"
  role = "${aws_iam_role.bs.name}"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Resource": "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/goracle-development"
    },
    {
      "Effect": "Allow",
      "Action": "s3:GetObject",
      "Resource": "arn:aws:s3:::twitch-sandstorm/sandstorm-agent.rpm"
    }
  ]
}
EOF
}
