# Goracle Runbook for Migrating to APLL Based Terraform

## Why is migration necessary?

In August 2018, the JTV corporate wifi network was no longer available, and the corporate keyhole proxy which allowed users to access JTV-based resources over the WPA2 (Amazon Corporate) network.  In order to keep Goracle available to users, the OE Tools team decided to split the beanstalks into Internal, and External beanstalks.  The internal beanstalk is on the JTV VPC, and the external network is accessible to the internet, with an APLL-based security group restriction, which limits access to the Amazon corporate network.

During this change, it was noticed that external facing beanstalks come with a default security group making them accessible to the entire internet.  Because we did not figure out how to suppress that security group upon beanstalk creation, we decided that it was an unacceptable risk to apply Terraform to the Goracle beanstalks until we figured this out.  So we made the changes to the Goracle beanstalks manually, and pushed the work to until after the network migration deadline.

In addition to the internal/external architecture change, a number of other changes needed to be made including moving beanstalk setup functionality out the .ebextensions folders into the Terraform scripts so that a beanstalk can be created in its final form before deploying the first build to it.

Given the significant changes that were made, it is extremely unlikely that Terraform would be able smoothly modify the beanstalk applications in-place, especially in the production environment.  In order to work around that, we've changed the s3 folder for goracle, so that Terraform will not try to destroy the old beanstalk, and the new beanstalk can be created and transitioned to after confirming their valid operation.

Going forward, once the APLL based Terraform is applied in the production and dev environments, it should be easy to make and apply new changes.

## Migrating the development environment

The initial run of the development environment's new Terraform has already been applied as part of the development process.  This created a new beanstalk application named 'servicecatalog-goracle-dev'.

### Setting up the instance profile role for service authentication.
  - Find the ARN of the load balancers' instance profile role, (currently set to arn:aws:iam::386434559102:role/servicecatalog-goracle-development)
  - Use the 'Manage Roles' tool in Sandstorm at https://dashboard.internal.justin.tv/sandstorm/ to add the instance profile role arn as an 'Allowed ARNs' to the 'goracle-development' role.  This will allow goracle to access its Sandstorm secrets.
  - Use the 'S2S' tool at https://dashboard.internal.justin.tv/s2s/services to add the instance profile role arn as an 'Allowed ARNs' to the 'service-catalog-dev' role.  This will allow goracle to interact with S2S.

These steps will only need to be repeated if the load balancers' instance profile role ARN changes.

### Ensure the TINKER_ENDPOINT variable is blank in the beanstalks' environment variable configuration.
  - Because of the current reverse proxy setup in goracle, the tinker and goracle environments need to point to each other.  We set this TINKER_ENDPOINT environment variable to point to a temporary instance of tinker, utilizing the servicecatalog-dev.internal.justin.tv URL.

### Modify the jenkins job to deploy to the new beanstalks
  - In the jenkins.groovy file (https://git-aws.internal.justin.tv/availability/goracle/blob/master/jenkins.groovy), modify the two 'eb deploy' lines to push builds to the new beanstalks ('servicecatalog-goracle-dev-int-env' and 'servicecatalog-goracle-dev-ext-env') instead of the old ones.

### Point the dns entries to the new beanstalks.
  - Set the internal facing dns entry for status-development.internal.justin.tv to the internal beanstalk's endpoint (servicecatalog-goracle-dev-int.us-west-2.elasticbeanstalk.com)
  - Set the external facing dns entry for status-development.internal.justin.tv to the external beanstalk's endpoint (servicecatalog-goracle-dev-ext.us-west-2.elasticbeanstalk.com)

### Manually destroy the old beanstalks once everything is confirmed to be working.


## Migrating the production environment

  - Set up AWS credentials for the twitch-central-aws account.
  - Switch to the ./terraform/production folder.
  - Run `terraform init`
  - Run `terraform plan`
  - Validate that no resources are to be destroyed.
  - Run `terraform apply`

### Setting up the instance profile role for service authentication.
  0 Find the ARN of the load balancers' instance profile role, (predicted to be arn:aws:iam::007917851548:role/servicecatalog-goracle-production)
  - Use the 'Manage Roles' tool in Sandstorm at https://dashboard.internal.justin.tv/sandstorm/ to add the instance profile role arn as an 'Allowed ARNs' to the 'goracle-production' role.  This will allow goracle to access its Sandstorm secrets.
  - Use the 'S2S' tool at https://dashboard.internal.justin.tv/s2s/services to add the instance profile role arn as an 'Allowed ARNs' to the 'service-catalog-prod' role.  This will allow goracle to interact with S2S.

These steps will only need to be repeated if the load balancers' instance profile role ARN changes.

### Ensure the TINKER_ENDPOINT variable is blank in the beanstalks' environment variable configuration.
  - Because of the current reverse proxy setup in goracle, the tinker and goracle environments need to point to each other.  
  - One can use the TINKER_ENDPOINT environment variable to point to a temporary instance of tinker, utilizing the servicecatalog.internal.justin.tv URL to validate that the new environment is fully functional before continuing.
  - If set, don't forget to unset the TINKER_ENDPOINT when ready to complete the migration.

### Modify the jenkins job to deploy to the new beanstalks
  - In the jenkins.groovy file (https://git-aws.internal.justin.tv/availability/goracle/blob/master/jenkins.groovy), modify the two 'eb deploy' lines to push builds to the new beanstalks ('servicecatalog-goracle-prod-int-env' and 'servicecatalog-goracle-prod-ext-env') instead of the old ones.

### Point the dns entries to the new beanstalks.
  - Set the internal facing dns entry for status.internal.justin.tv to the internal beanstalk's endpoint (servicecatalog-goracle-prod-int.us-west-2.elasticbeanstalk.com)
  - Set the external facing dns entry for status.internal.justin.tv to the external beanstalk's endpoint (servicecatalog-goracle-prod-ext.us-west-2.elasticbeanstalk.com)

### Manually destroy the old beanstalks once everything is confirmed to be working.
