resource "aws_elastic_beanstalk_configuration_template" "bs" {
  name                = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-placeholder-template"
  description         = "placeholder to allow the user to optionally specify a template"
  application         = "${var.eb_application_name}"
  solution_stack_name = "${var.solution_stack_name}"
}

resource "aws_elastic_beanstalk_environment" "bs" {
  name         = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-env"
  description  = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  application  = "${var.eb_application_name}"
  tier         = "WebServer"

  cname_prefix = "${coalesce(var.cname_prefix, null_resource.vars.triggers.cn)}"

  tags {
    Environment = "${var.env}"
    Service     = "${var.service}"
    Owner       = "${var.owner}"
    Skeleton    = "dta/docker-eb-tf-skeleton@76d7aaf7c2f2b8ece2c81642502f3e2bae454ce4"
  }

  wait_for_ready_timeout = "${var.wait_for_ready_timeout}"
  template_name          = "${coalesce(var.eb_config_template_name, aws_elastic_beanstalk_configuration_template.bs.name)}"

  # Vpc  and network related settings
  setting {
    namespace = "aws:ec2:vpc"
    name      = "VPCId"
    value     = "${var.vpc_id}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "Subnets"
    value     = "${var.ec2_subnet_ids}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBSubnets"
    value     = "${var.elb_subnet_ids}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "AssociatePublicIpAddress"
    value     = "${var.associate_public_address}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBScheme"
    value     = "${var.elb_scheme}"
  }

  # Load Balancer Related Settings
  setting {
    namespace = "aws:elb:loadbalancer"
    name      = "SecurityGroups"
    value     = "${var.elb_loadbalancer_security_groups}"
  }

  setting {
    namespace = "aws:elb:loadbalancer"
    name      = "ManagedSecurityGroup"
    value     = "${var.elb_loadbalancer_security_groups}"
  }

  setting {
    namespace = "aws:elb:loadbalancer"
    name      = "LoadBalancerHTTPSPort"
    value     = "443"
  }

  setting {
    namespace = "aws:elb:loadbalancer"
    name      = "SSLCertificateId"
    value     = "${var.elb_loadbalancer_ssl_cert}"
  }

  setting {
    namespace = "aws:elb:listener:80"
    name      = "ListenerProtocol"
    value     = "HTTP"
  }



  # asg launch configuration settings
  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "IamInstanceProfile"
    value     = "${var.auto_scaling_lc_iam_instance_profile}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "InstanceType"
    value     = "${var.auto_scaling_lc_instance_type}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "MonitoringInterval"
    value     = "${var.auto_scaling_lc_monitoring_interval}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "SecurityGroups"
    value     = "${var.auto_scaling_lc_security_groups}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeType"
    value     = "${var.auto_scaling_lc_root_volume_type}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeSize"
    value     = "${var.auto_scaling_lc_root_volume_size}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeIOPS"
    value     = "${var.auto_scaling_lc_root_volume_iops}"
  }

  # Set ASG size
  setting {
    namespace = "aws:autoscaling:asg"
    name      = "MinSize"
    value     = "${var.asg_min_size}"
  }

  setting {
    namespace = "aws:autoscaling:asg"
    name      = "MaxSize"
    value     = "${var.asg_max_size}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "DeploymentPolicy"
    value     = "Rolling"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "BatchSizeType"
    value     = "Percentage"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "BatchSize"
    value     = "50"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateType"
    value     = "Health"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateEnabled"
    value     = "true"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "PauseTime"
    value     = "PT0S"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "MaxBatchSize"
    value     = "2"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application"
    name      = "Application Healthcheck URL"
    value     = "/debug/running"
  }

  setting {
    namespace = "aws:elasticbeanstalk:healthreporting:system"
    name      = "SystemType"
    value     = "enhanced"
  }

  setting {
    namespace = "aws:elb:healthcheck"
    name      = "Target"
    value     = "HTTP:80/debug/running"
  }

  setting {
    namespace = "aws:elasticbeanstalk:healthreporting:system"
    name      = "ConfigDocument"
    value     = "{\"Version\":1,\"CloudWatchMetrics\":{\"Instance\":{\"RootFilesystemUtil\":60,\"CPUIrq\":60,\"LoadAverage5min\":60,\"ApplicationRequests5xx\":60,\"ApplicationRequests4xx\":60,\"CPUUser\":60,\"LoadAverage1min\":60,\"ApplicationLatencyP50\":60,\"CPUIdle\":60,\"InstanceHealth\":60,\"ApplicationLatencyP95\":60,\"ApplicationLatencyP85\":60,\"ApplicationLatencyP90\":60,\"CPUSystem\":60,\"ApplicationLatencyP75\":60,\"CPUSoftirq\":60,\"ApplicationLatencyP10\":60,\"ApplicationLatencyP99\":60,\"ApplicationRequestsTotal\":60,\"ApplicationLatencyP99.9\":60,\"ApplicationRequests3xx\":60,\"ApplicationRequests2xx\":60,\"CPUIowait\":60,\"CPUNice\":60},\"Environment\":{\"InstancesSevere\":60,\"InstancesDegraded\":60,\"ApplicationRequests5xx\":60,\"ApplicationRequests4xx\":60,\"ApplicationLatencyP50\":60,\"ApplicationLatencyP95\":60,\"ApplicationLatencyP85\":60,\"InstancesUnknown\":60,\"ApplicationLatencyP90\":60,\"InstancesInfo\":60,\"InstancesPending\":60,\"ApplicationLatencyP75\":60,\"ApplicationLatencyP10\":60,\"ApplicationLatencyP99\":60,\"ApplicationRequestsTotal\":60,\"InstancesNoData\":60,\"ApplicationLatencyP99.9\":60,\"ApplicationRequests3xx\":60,\"ApplicationRequests2xx\":60,\"InstancesOk\":60,\"InstancesWarning\":60}}}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ENV_NAME"
    value     = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-env"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "APP"
    value     = "${var.eb_application_name}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "STATSD_HOST_PORT"
    value     = "${var.statsd_host}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ENVIRONMENT"
    value     = "${var.environment_environment_var == "" ? var.env : var.environment_environment_var}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "FLAG_SERVICE_CATALOG"
    value     = "${var.flag_service_catalog}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "DEBUG_SEND_EMAIL"
    value     = "${var.debug_send_email}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ENABLE_V1_API"
    value     = "${var.enable_v1_api}"
  }

  # eb environment settings
  setting {
    namespace = "aws:elasticbeanstalk:environment"
    name      = "ServiceRole"
    value     = "${var.eb_environment_service_role}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:sns:topics"
    name      = "Notification Protocol"
    value     = "email"
  }

  setting {
    namespace = "aws:elasticbeanstalk:sns:topics"
    name      = "Notification Endpoint"
    value     = "${var.owner}"
  }

}
