

module "goracle-bs-production-int" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-aws"
  eb_application_name = "${module.bs-app-production.beanstalk_application_name}"
  vpc_id = "vpc-bda8eed9"
  ec2_subnet_ids = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  elb_subnet_ids = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  elb_loadbalancer_security_groups = "sg-1825527e"
  auto_scaling_lc_security_groups = "sg-1825527e"
  auto_scaling_lc_iam_instance_profile = "${aws_iam_role.bs.id}"
  elb_loadbalancer_ssl_cert = "arn:aws:acm:us-west-2:007917851548:certificate/e95907a1-6cc7-46e8-aace-322b2fcf2664"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.2 running Docker 18.03.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "oe-tools@justin.tv"
  service = "availability/goracle"
  env = "production"
  associate_public_address = "false"
  cname_prefix = "servicecatalog-goracle-prod-int"
  common_name = "servicecatalog-goracle-prod-int"
  asg_min_size = "4"
  asg_max_size = "8"
  enable_v1_api = "true"
}

module "goracle-bs-production-ext" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-aws"
  eb_application_name = "${module.bs-app-production.beanstalk_application_name}"
  vpc_id = "vpc-bda8eed9"
  ec2_subnet_ids = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  elb_subnet_ids = "subnet-e487f080,subnet-0cb8367a,subnet-818650d9"
  elb_loadbalancer_security_groups = "sg-0c9dc76b8b347ad96"
  auto_scaling_lc_security_groups = "sg-1825527e"
  elb_loadbalancer_ssl_cert = "arn:aws:acm:us-west-2:007917851548:certificate/e95907a1-6cc7-46e8-aace-322b2fcf2664"
  auto_scaling_lc_iam_instance_profile = "${aws_iam_role.bs.id}"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.2 running Docker 18.03.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "oe-tools@justin.tv"
  service = "availability/goracle"
  env = "production"
  associate_public_address = "false"
  cname_prefix = "servicecatalog-goracle-prod-ext"
  common_name = "servicecatalog-goracle-prod-ext"
  elb_scheme = "public"
  asg_min_size = "4"
  asg_max_size = "8"
}
