package twitchclient

import (
	"context"
	"log"
)

type defaultLogger struct{}

func (l *defaultLogger) DebugCtx(ctx context.Context, params ...interface{}) {}
func (l *defaultLogger) Debug(params ...interface{})                         {}

func (l *defaultLogger) LogCtx(ctx context.Context, params ...interface{}) {
	log.Println(params)
}

func (l *defaultLogger) Log(params ...interface{}) {
	l.LogCtx(context.Background(), params)
}

// ctxDimensions can propagate log dimensions inside a context object
type ctxDimensions struct {
	dimensionKey interface{}
}

// From returns the dimensions currently set inside a context object
func (c *ctxDimensions) From(ctx context.Context) []interface{} {
	existing := ctx.Value(c.dimensionKey)
	if existing == nil {
		return []interface{}{}
	}
	return existing.([]interface{})
}

// Append returns a new context that appends vals as dimensions for logging
func (c *ctxDimensions) Append(ctx context.Context, vals ...interface{}) context.Context {
	if len(vals) == 0 {
		return ctx
	}
	if len(vals)%2 != 0 {
		panic("Expected even number of values")
	}
	existing := c.From(ctx)
	newArr := make([]interface{}, 0, len(existing)+len(vals))
	newArr = append(newArr, existing...)
	newArr = append(newArr, vals...)
	return context.WithValue(ctx, c.dimensionKey, newArr)
}
