package events

// Event is the base to all events
type Event struct {
	Name            string `json:"event"`
	Category        string `json:"category"`
	IPAddress       string `json:"ip_address"`
	ServiceName     string `json:"service_name"`
	ServiceID       string `json:"service_id"`
	HostName        string `json:"hostname"`
	LDAPUser        string `json:"ldap_user"`
	AWSPrincipal    string `json:"aws_principal"`
	CallerID        string `json:"caller_id"`
	CallerName      string `json:"caller_name"`
	CalleeID        string `json:"callee_id"`
	CalleeName      string `json:"callee_name"`
	JWTID           string `json:"jwt_id"`
	StatusCode      string `json:"status_code"`
	URLPath         string `json:"url_path"`
	PassthroughMode string `json:"passthrough_mode"`
	Message         string `json:"message"`
}

// FillDefaults will fill the defaults of another event
func (e *Event) FillDefaults(other interface{}) {

	switch otherEvent := other.(type) {
	case *Event:
		e.fillDefaults(otherEvent)
	}
}

func (e *Event) fillDefaults(otherEvent *Event) {
	if otherEvent == nil {
		return
	}

	if otherEvent.Name == "" {
		otherEvent.Name = e.Name
	}
	if otherEvent.Category == "" {
		otherEvent.Category = e.Category
	}
	if otherEvent.IPAddress == "" {
		otherEvent.IPAddress = e.IPAddress
	}
	if otherEvent.ServiceName == "" {
		otherEvent.ServiceName = e.ServiceName
	}
	if otherEvent.ServiceID == "" {
		otherEvent.ServiceID = e.ServiceID
	}
	if otherEvent.HostName == "" {
		otherEvent.HostName = e.HostName
	}
	if otherEvent.LDAPUser == "" {
		otherEvent.LDAPUser = e.LDAPUser
	}
	if otherEvent.AWSPrincipal == "" {
		otherEvent.AWSPrincipal = e.AWSPrincipal
	}
	if otherEvent.CallerID == "" {
		otherEvent.CallerID = e.CallerID
	}
	if otherEvent.CallerName == "" {
		otherEvent.CallerName = e.CallerName
	}
	if otherEvent.CalleeID == "" {
		otherEvent.CalleeID = e.CalleeID
	}
	if otherEvent.CalleeName == "" {
		otherEvent.CalleeName = e.CalleeName
	}
	if otherEvent.JWTID == "" {
		otherEvent.JWTID = e.JWTID
	}
	if otherEvent.StatusCode == "" {
		otherEvent.StatusCode = e.StatusCode
	}
	if otherEvent.URLPath == "" {
		otherEvent.URLPath = e.URLPath
	}
	if otherEvent.PassthroughMode == "" {
		otherEvent.PassthroughMode = e.PassthroughMode
	}
	if otherEvent.Message == "" {
		otherEvent.Message = e.Message
	}
}
