// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddLayerVersionPermission = "AddLayerVersionPermission"

// AddLayerVersionPermissionRequest generates a "aws/request.Request" representing the
// client's request for the AddLayerVersionPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddLayerVersionPermission for more information on using the AddLayerVersionPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddLayerVersionPermissionRequest method.
//    req, resp := client.AddLayerVersionPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission
func (c *Lambda) AddLayerVersionPermissionRequest(input *AddLayerVersionPermissionInput) (req *request.Request, output *AddLayerVersionPermissionOutput) {
	op := &request.Operation{
		Name:       opAddLayerVersionPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
	}

	if input == nil {
		input = &AddLayerVersionPermissionInput{}
	}

	output = &AddLayerVersionPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddLayerVersionPermission API operation for AWS Lambda.
//
// Adds permissions to the resource-based policy of a version of a function
// layer. Use this action to grant layer usage permission to other accounts.
// You can grant permission to a single account, all AWS accounts, or all accounts
// in an organization.
//
// To revoke permission, call RemoveLayerVersionPermission with the statement
// ID that you specified when you added it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation AddLayerVersionPermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodePolicyLengthExceededException "PolicyLengthExceededException"
//   Lambda function access policy is limited to 20 KB.
//
//   * ErrCodePreconditionFailedException "PreconditionFailedException"
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission
func (c *Lambda) AddLayerVersionPermission(input *AddLayerVersionPermissionInput) (*AddLayerVersionPermissionOutput, error) {
	req, out := c.AddLayerVersionPermissionRequest(input)
	return out, req.Send()
}

// AddLayerVersionPermissionWithContext is the same as AddLayerVersionPermission with the addition of
// the ability to pass a context and additional request options.
//
// See AddLayerVersionPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) AddLayerVersionPermissionWithContext(ctx aws.Context, input *AddLayerVersionPermissionInput, opts ...request.Option) (*AddLayerVersionPermissionOutput, error) {
	req, out := c.AddLayerVersionPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddPermission = "AddPermission"

// AddPermissionRequest generates a "aws/request.Request" representing the
// client's request for the AddPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddPermission for more information on using the AddPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddPermissionRequest method.
//    req, resp := client.AddPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission
func (c *Lambda) AddPermissionRequest(input *AddPermissionInput) (req *request.Request, output *AddPermissionOutput) {
	op := &request.Operation{
		Name:       opAddPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy",
	}

	if input == nil {
		input = &AddPermissionInput{}
	}

	output = &AddPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddPermission API operation for AWS Lambda.
//
// Adds a permission to the resource policy associated with the specified AWS
// Lambda function. You use resource policies to grant permissions to event
// sources that use the push model. In a push model, event sources (such as
// Amazon S3 and custom applications) invoke your Lambda function. Each permission
// you add to the resource policy allows an event source permission to invoke
// the Lambda function.
//
// Permissions apply to the Amazon Resource Name (ARN) used to invoke the function,
// which can be unqualified (the unpublished version of the function), or include
// a version or alias. If a client uses a version or alias to invoke a function,
// use the Qualifier parameter to apply permissions to that ARN. For more information
// about versioning, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:AddPermission action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation AddPermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodePolicyLengthExceededException "PolicyLengthExceededException"
//   Lambda function access policy is limited to 20 KB.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodePreconditionFailedException "PreconditionFailedException"
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission
func (c *Lambda) AddPermission(input *AddPermissionInput) (*AddPermissionOutput, error) {
	req, out := c.AddPermissionRequest(input)
	return out, req.Send()
}

// AddPermissionWithContext is the same as AddPermission with the addition of
// the ability to pass a context and additional request options.
//
// See AddPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) AddPermissionWithContext(ctx aws.Context, input *AddPermissionInput, opts ...request.Option) (*AddPermissionOutput, error) {
	req, out := c.AddPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlias for more information on using the CreateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAliasRequest method.
//    req, resp := client.CreateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias
func (c *Lambda) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &AliasConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlias API operation for AWS Lambda.
//
// Creates an alias that points to the specified Lambda function version. For
// more information, see Introduction to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// Alias names are unique for a given function. This requires permission for
// the lambda:CreateAlias action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation CreateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias
func (c *Lambda) CreateAlias(input *CreateAliasInput) (*AliasConfiguration, error) {
	req, out := c.CreateAliasRequest(input)
	return out, req.Send()
}

// CreateAliasWithContext is the same as CreateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) CreateAliasWithContext(ctx aws.Context, input *CreateAliasInput, opts ...request.Option) (*AliasConfiguration, error) {
	req, out := c.CreateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventSourceMapping = "CreateEventSourceMapping"

// CreateEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSourceMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventSourceMapping for more information on using the CreateEventSourceMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventSourceMappingRequest method.
//    req, resp := client.CreateEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping
func (c *Lambda) CreateEventSourceMappingRequest(input *CreateEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opCreateEventSourceMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
	}

	if input == nil {
		input = &CreateEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSourceMapping API operation for AWS Lambda.
//
// Creates a mapping between an event source and an AWS Lambda function. Lambda
// reads items from the event source and triggers the function.
//
// For details about each event source type, see the following topics.
//
//    * Using AWS Lambda with Amazon Kinesis (http://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html)
//
//    * Using AWS Lambda with Amazon SQS (http://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html)
//
//    * Using AWS Lambda with Amazon DynamoDB (http://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation CreateEventSourceMapping for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping
func (c *Lambda) CreateEventSourceMapping(input *CreateEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.CreateEventSourceMappingRequest(input)
	return out, req.Send()
}

// CreateEventSourceMappingWithContext is the same as CreateEventSourceMapping with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventSourceMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) CreateEventSourceMappingWithContext(ctx aws.Context, input *CreateEventSourceMappingInput, opts ...request.Option) (*EventSourceMappingConfiguration, error) {
	req, out := c.CreateEventSourceMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFunction = "CreateFunction"

// CreateFunctionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFunction for more information on using the CreateFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFunctionRequest method.
//    req, resp := client.CreateFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction
func (c *Lambda) CreateFunctionRequest(input *CreateFunctionInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opCreateFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions",
	}

	if input == nil {
		input = &CreateFunctionInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFunction API operation for AWS Lambda.
//
// Creates a new Lambda function. The function configuration is created from
// the request parameters, and the code for the function is provided by a .zip
// file. The function name is case-sensitive.
//
// This operation requires permission for the lambda:CreateFunction action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation CreateFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeCodeStorageExceededException "CodeStorageExceededException"
//   You have exceeded your maximum total code size per account. Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction
func (c *Lambda) CreateFunction(input *CreateFunctionInput) (*FunctionConfiguration, error) {
	req, out := c.CreateFunctionRequest(input)
	return out, req.Send()
}

// CreateFunctionWithContext is the same as CreateFunction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) CreateFunctionWithContext(ctx aws.Context, input *CreateFunctionInput, opts ...request.Option) (*FunctionConfiguration, error) {
	req, out := c.CreateFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlias for more information on using the DeleteAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAliasRequest method.
//    req, resp := client.DeleteAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias
func (c *Lambda) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output = &DeleteAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlias API operation for AWS Lambda.
//
// Deletes the specified Lambda function alias. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:DeleteAlias action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias
func (c *Lambda) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	return out, req.Send()
}

// DeleteAliasWithContext is the same as DeleteAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteAliasWithContext(ctx aws.Context, input *DeleteAliasInput, opts ...request.Option) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventSourceMapping = "DeleteEventSourceMapping"

// DeleteEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSourceMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventSourceMapping for more information on using the DeleteEventSourceMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventSourceMappingRequest method.
//    req, resp := client.DeleteEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping
func (c *Lambda) DeleteEventSourceMappingRequest(input *DeleteEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opDeleteEventSourceMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &DeleteEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventSourceMapping API operation for AWS Lambda.
//
// Deletes an event source mapping.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteEventSourceMapping for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to update an EventSoure Mapping in CREATING, or tried to delete
//   a EventSoure mapping currently in the UPDATING state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping
func (c *Lambda) DeleteEventSourceMapping(input *DeleteEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.DeleteEventSourceMappingRequest(input)
	return out, req.Send()
}

// DeleteEventSourceMappingWithContext is the same as DeleteEventSourceMapping with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventSourceMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteEventSourceMappingWithContext(ctx aws.Context, input *DeleteEventSourceMappingInput, opts ...request.Option) (*EventSourceMappingConfiguration, error) {
	req, out := c.DeleteEventSourceMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFunction = "DeleteFunction"

// DeleteFunctionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFunction for more information on using the DeleteFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFunctionRequest method.
//    req, resp := client.DeleteFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction
func (c *Lambda) DeleteFunctionRequest(input *DeleteFunctionInput) (req *request.Request, output *DeleteFunctionOutput) {
	op := &request.Operation{
		Name:       opDeleteFunction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &DeleteFunctionInput{}
	}

	output = &DeleteFunctionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFunction API operation for AWS Lambda.
//
// Deletes a Lambda function. To delete a specific function version, use the
// Qualifier parameter. Otherwise, all versions and aliases are deleted. Event
// source mappings are not deleted.
//
// This operation requires permission for the lambda:DeleteFunction action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction
func (c *Lambda) DeleteFunction(input *DeleteFunctionInput) (*DeleteFunctionOutput, error) {
	req, out := c.DeleteFunctionRequest(input)
	return out, req.Send()
}

// DeleteFunctionWithContext is the same as DeleteFunction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteFunctionWithContext(ctx aws.Context, input *DeleteFunctionInput, opts ...request.Option) (*DeleteFunctionOutput, error) {
	req, out := c.DeleteFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFunctionConcurrency = "DeleteFunctionConcurrency"

// DeleteFunctionConcurrencyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFunctionConcurrency operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFunctionConcurrency for more information on using the DeleteFunctionConcurrency
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFunctionConcurrencyRequest method.
//    req, resp := client.DeleteFunctionConcurrencyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency
func (c *Lambda) DeleteFunctionConcurrencyRequest(input *DeleteFunctionConcurrencyInput) (req *request.Request, output *DeleteFunctionConcurrencyOutput) {
	op := &request.Operation{
		Name:       opDeleteFunctionConcurrency,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2017-10-31/functions/{FunctionName}/concurrency",
	}

	if input == nil {
		input = &DeleteFunctionConcurrencyInput{}
	}

	output = &DeleteFunctionConcurrencyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFunctionConcurrency API operation for AWS Lambda.
//
// Removes concurrent execution limits from this function. For more information,
// see Managing Concurrency (http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteFunctionConcurrency for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency
func (c *Lambda) DeleteFunctionConcurrency(input *DeleteFunctionConcurrencyInput) (*DeleteFunctionConcurrencyOutput, error) {
	req, out := c.DeleteFunctionConcurrencyRequest(input)
	return out, req.Send()
}

// DeleteFunctionConcurrencyWithContext is the same as DeleteFunctionConcurrency with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFunctionConcurrency for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteFunctionConcurrencyWithContext(ctx aws.Context, input *DeleteFunctionConcurrencyInput, opts ...request.Option) (*DeleteFunctionConcurrencyOutput, error) {
	req, out := c.DeleteFunctionConcurrencyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLayerVersion = "DeleteLayerVersion"

// DeleteLayerVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLayerVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLayerVersion for more information on using the DeleteLayerVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLayerVersionRequest method.
//    req, resp := client.DeleteLayerVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion
func (c *Lambda) DeleteLayerVersionRequest(input *DeleteLayerVersionInput) (req *request.Request, output *DeleteLayerVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteLayerVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}",
	}

	if input == nil {
		input = &DeleteLayerVersionInput{}
	}

	output = &DeleteLayerVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLayerVersion API operation for AWS Lambda.
//
// Deletes a version of a function layer. Deleted versions can no longer be
// viewed or added to functions. However, a copy of the version remains in Lambda
// until no functions refer to it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteLayerVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion
func (c *Lambda) DeleteLayerVersion(input *DeleteLayerVersionInput) (*DeleteLayerVersionOutput, error) {
	req, out := c.DeleteLayerVersionRequest(input)
	return out, req.Send()
}

// DeleteLayerVersionWithContext is the same as DeleteLayerVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLayerVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteLayerVersionWithContext(ctx aws.Context, input *DeleteLayerVersionInput, opts ...request.Option) (*DeleteLayerVersionOutput, error) {
	req, out := c.DeleteLayerVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountSettings for more information on using the GetAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountSettingsRequest method.
//    req, resp := client.GetAccountSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings
func (c *Lambda) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-08-19/account-settings/",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for AWS Lambda.
//
// Retrieves details about your account's limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html)
// and usage in a region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings
func (c *Lambda) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	return out, req.Send()
}

// GetAccountSettingsWithContext is the same as GetAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetAccountSettingsWithContext(ctx aws.Context, input *GetAccountSettingsInput, opts ...request.Option) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAlias = "GetAlias"

// GetAliasRequest generates a "aws/request.Request" representing the
// client's request for the GetAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAlias for more information on using the GetAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAliasRequest method.
//    req, resp := client.GetAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias
func (c *Lambda) GetAliasRequest(input *GetAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opGetAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &GetAliasInput{}
	}

	output = &AliasConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetAlias API operation for AWS Lambda.
//
// Returns the specified alias information such as the alias ARN, description,
// and function version it is pointing to. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:GetAlias action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias
func (c *Lambda) GetAlias(input *GetAliasInput) (*AliasConfiguration, error) {
	req, out := c.GetAliasRequest(input)
	return out, req.Send()
}

// GetAliasWithContext is the same as GetAlias with the addition of
// the ability to pass a context and additional request options.
//
// See GetAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetAliasWithContext(ctx aws.Context, input *GetAliasInput, opts ...request.Option) (*AliasConfiguration, error) {
	req, out := c.GetAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventSourceMapping = "GetEventSourceMapping"

// GetEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the GetEventSourceMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventSourceMapping for more information on using the GetEventSourceMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventSourceMappingRequest method.
//    req, resp := client.GetEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping
func (c *Lambda) GetEventSourceMappingRequest(input *GetEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opGetEventSourceMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &GetEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventSourceMapping API operation for AWS Lambda.
//
// Returns details about an event source mapping.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetEventSourceMapping for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping
func (c *Lambda) GetEventSourceMapping(input *GetEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.GetEventSourceMappingRequest(input)
	return out, req.Send()
}

// GetEventSourceMappingWithContext is the same as GetEventSourceMapping with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventSourceMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetEventSourceMappingWithContext(ctx aws.Context, input *GetEventSourceMappingInput, opts ...request.Option) (*EventSourceMappingConfiguration, error) {
	req, out := c.GetEventSourceMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunction = "GetFunction"

// GetFunctionRequest generates a "aws/request.Request" representing the
// client's request for the GetFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunction for more information on using the GetFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionRequest method.
//    req, resp := client.GetFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction
func (c *Lambda) GetFunctionRequest(input *GetFunctionInput) (req *request.Request, output *GetFunctionOutput) {
	op := &request.Operation{
		Name:       opGetFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &GetFunctionInput{}
	}

	output = &GetFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunction API operation for AWS Lambda.
//
// Returns the configuration information of the Lambda function and a presigned
// URL link to the .zip file you uploaded with CreateFunction so you can download
// the .zip file. Note that the URL is valid for up to 10 minutes. The configuration
// information is the same information you provided as parameters when uploading
// the function.
//
// Use the Qualifier parameter to retrieve a published version of the function.
// Otherwise, returns the unpublished version ($LATEST). For more information,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:GetFunction action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction
func (c *Lambda) GetFunction(input *GetFunctionInput) (*GetFunctionOutput, error) {
	req, out := c.GetFunctionRequest(input)
	return out, req.Send()
}

// GetFunctionWithContext is the same as GetFunction with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetFunctionWithContext(ctx aws.Context, input *GetFunctionInput, opts ...request.Option) (*GetFunctionOutput, error) {
	req, out := c.GetFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunctionConfiguration = "GetFunctionConfiguration"

// GetFunctionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetFunctionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunctionConfiguration for more information on using the GetFunctionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionConfigurationRequest method.
//    req, resp := client.GetFunctionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration
func (c *Lambda) GetFunctionConfigurationRequest(input *GetFunctionConfigurationInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opGetFunctionConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/configuration",
	}

	if input == nil {
		input = &GetFunctionConfigurationInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunctionConfiguration API operation for AWS Lambda.
//
// Returns the configuration information of the Lambda function. This the same
// information you provided as parameters when uploading the function by using
// CreateFunction.
//
// If you are using the versioning feature, you can retrieve this information
// for a specific function version by using the optional Qualifier parameter
// and specifying the function version or alias that points to it. If you don't
// provide it, the API returns information about the $LATEST version of the
// function. For more information about versioning, see AWS Lambda Function
// Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:GetFunctionConfiguration
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetFunctionConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration
func (c *Lambda) GetFunctionConfiguration(input *GetFunctionConfigurationInput) (*FunctionConfiguration, error) {
	req, out := c.GetFunctionConfigurationRequest(input)
	return out, req.Send()
}

// GetFunctionConfigurationWithContext is the same as GetFunctionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunctionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetFunctionConfigurationWithContext(ctx aws.Context, input *GetFunctionConfigurationInput, opts ...request.Option) (*FunctionConfiguration, error) {
	req, out := c.GetFunctionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLayerVersion = "GetLayerVersion"

// GetLayerVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetLayerVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLayerVersion for more information on using the GetLayerVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLayerVersionRequest method.
//    req, resp := client.GetLayerVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion
func (c *Lambda) GetLayerVersionRequest(input *GetLayerVersionInput) (req *request.Request, output *GetLayerVersionOutput) {
	op := &request.Operation{
		Name:       opGetLayerVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}",
	}

	if input == nil {
		input = &GetLayerVersionInput{}
	}

	output = &GetLayerVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLayerVersion API operation for AWS Lambda.
//
// Returns information about a version of a function layer, with a link to download
// the layer archive that's valid for 10 minutes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetLayerVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion
func (c *Lambda) GetLayerVersion(input *GetLayerVersionInput) (*GetLayerVersionOutput, error) {
	req, out := c.GetLayerVersionRequest(input)
	return out, req.Send()
}

// GetLayerVersionWithContext is the same as GetLayerVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetLayerVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetLayerVersionWithContext(ctx aws.Context, input *GetLayerVersionInput, opts ...request.Option) (*GetLayerVersionOutput, error) {
	req, out := c.GetLayerVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLayerVersionPolicy = "GetLayerVersionPolicy"

// GetLayerVersionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetLayerVersionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLayerVersionPolicy for more information on using the GetLayerVersionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLayerVersionPolicyRequest method.
//    req, resp := client.GetLayerVersionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy
func (c *Lambda) GetLayerVersionPolicyRequest(input *GetLayerVersionPolicyInput) (req *request.Request, output *GetLayerVersionPolicyOutput) {
	op := &request.Operation{
		Name:       opGetLayerVersionPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
	}

	if input == nil {
		input = &GetLayerVersionPolicyInput{}
	}

	output = &GetLayerVersionPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLayerVersionPolicy API operation for AWS Lambda.
//
// Returns the permission policy for a layer version. For more information,
// see AddLayerVersionPermission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetLayerVersionPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy
func (c *Lambda) GetLayerVersionPolicy(input *GetLayerVersionPolicyInput) (*GetLayerVersionPolicyOutput, error) {
	req, out := c.GetLayerVersionPolicyRequest(input)
	return out, req.Send()
}

// GetLayerVersionPolicyWithContext is the same as GetLayerVersionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetLayerVersionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetLayerVersionPolicyWithContext(ctx aws.Context, input *GetLayerVersionPolicyInput, opts ...request.Option) (*GetLayerVersionPolicyOutput, error) {
	req, out := c.GetLayerVersionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicy for more information on using the GetPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPolicyRequest method.
//    req, resp := client.GetPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy
func (c *Lambda) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for AWS Lambda.
//
// Returns the resource policy associated with the specified Lambda function.
//
// This action requires permission for the lambda:GetPolicy action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy
func (c *Lambda) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetPolicyWithContext(ctx aws.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInvoke = "Invoke"

// InvokeRequest generates a "aws/request.Request" representing the
// client's request for the Invoke operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Invoke for more information on using the Invoke
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InvokeRequest method.
//    req, resp := client.InvokeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke
func (c *Lambda) InvokeRequest(input *InvokeInput) (req *request.Request, output *InvokeOutput) {
	op := &request.Operation{
		Name:       opInvoke,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/invocations",
	}

	if input == nil {
		input = &InvokeInput{}
	}

	output = &InvokeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Invoke API operation for AWS Lambda.
//
// Invokes a Lambda function. For an example, see Create the Lambda Function
// and Test It Manually (http://docs.aws.amazon.com/lambda/latest/dg/with-dynamodb-create-function.html#with-dbb-invoke-manually).
//
// Specify just a function name to invoke the latest version of the function.
// To invoke a published version, use the Qualifier parameter to specify a version
// or alias (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// If you use the RequestResponse (synchronous) invocation option, the function
// will be invoked only once. If you use the Event (asynchronous) invocation
// option, the function will be invoked at least once in response to an event
// and the function must be idempotent to handle this.
//
// For functions with a long timeout, your client may be disconnected during
// synchronous invocation while it waits for a response. Configure your HTTP
// client, SDK, firewall, proxy, or operating system to allow for long connections
// with timeout or keep-alive settings.
//
// This operation requires permission for the lambda:InvokeFunction action.
//
// The TooManyRequestsException noted below will return the following: ConcurrentInvocationLimitExceeded
// will be returned if you have no functions with reserved concurrency and have
// exceeded your account concurrent limit or if a function without reserved
// concurrency exceeds the account's unreserved concurrency limit. ReservedFunctionConcurrentInvocationLimitExceeded
// will be returned when a function with reserved concurrency exceeds its configured
// concurrency limit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation Invoke for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidRequestContentException "InvalidRequestContentException"
//   The request body could not be parsed as JSON.
//
//   * ErrCodeRequestTooLargeException "RequestTooLargeException"
//   The request payload exceeded the Invoke request body JSON input limit. For
//   more information, see Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html).
//
//   * ErrCodeUnsupportedMediaTypeException "UnsupportedMediaTypeException"
//   The content type of the Invoke request body is not JSON.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeEC2UnexpectedException "EC2UnexpectedException"
//   AWS Lambda received an unexpected EC2 client exception while setting up for
//   the Lambda function.
//
//   * ErrCodeSubnetIPAddressLimitReachedException "SubnetIPAddressLimitReachedException"
//   AWS Lambda was not able to set up VPC access for the Lambda function because
//   one or more configured subnets has no available IP addresses.
//
//   * ErrCodeENILimitReachedException "ENILimitReachedException"
//   AWS Lambda was not able to create an Elastic Network Interface (ENI) in the
//   VPC, specified as part of Lambda function configuration, because the limit
//   for network interfaces has been reached.
//
//   * ErrCodeEC2ThrottledException "EC2ThrottledException"
//   AWS Lambda was throttled by Amazon EC2 during Lambda function initialization
//   using the execution role provided for the Lambda function.
//
//   * ErrCodeEC2AccessDeniedException "EC2AccessDeniedException"
//   Need additional permissions to configure VPC settings.
//
//   * ErrCodeInvalidSubnetIDException "InvalidSubnetIDException"
//   The Subnet ID provided in the Lambda function VPC configuration is invalid.
//
//   * ErrCodeInvalidSecurityGroupIDException "InvalidSecurityGroupIDException"
//   The Security Group ID provided in the Lambda function VPC configuration is
//   invalid.
//
//   * ErrCodeInvalidZipFileException "InvalidZipFileException"
//   AWS Lambda could not unzip the deployment package.
//
//   * ErrCodeKMSDisabledException "KMSDisabledException"
//   Lambda was unable to decrypt the environment variables because the KMS key
//   used is disabled. Check the Lambda function's KMS key settings.
//
//   * ErrCodeKMSInvalidStateException "KMSInvalidStateException"
//   Lambda was unable to decrypt the environment variables because the KMS key
//   used is in an invalid state for Decrypt. Check the function's KMS key settings.
//
//   * ErrCodeKMSAccessDeniedException "KMSAccessDeniedException"
//   Lambda was unable to decrypt the environment variables because KMS access
//   was denied. Check the Lambda function's KMS permissions.
//
//   * ErrCodeKMSNotFoundException "KMSNotFoundException"
//   Lambda was unable to decrypt the environment variables because the KMS key
//   was not found. Check the function's KMS key settings.
//
//   * ErrCodeInvalidRuntimeException "InvalidRuntimeException"
//   The runtime or runtime version specified is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke
func (c *Lambda) Invoke(input *InvokeInput) (*InvokeOutput, error) {
	req, out := c.InvokeRequest(input)
	return out, req.Send()
}

// InvokeWithContext is the same as Invoke with the addition of
// the ability to pass a context and additional request options.
//
// See Invoke for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) InvokeWithContext(ctx aws.Context, input *InvokeInput, opts ...request.Option) (*InvokeOutput, error) {
	req, out := c.InvokeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInvokeAsync = "InvokeAsync"

// InvokeAsyncRequest generates a "aws/request.Request" representing the
// client's request for the InvokeAsync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InvokeAsync for more information on using the InvokeAsync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InvokeAsyncRequest method.
//    req, resp := client.InvokeAsyncRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvokeAsync
//
// Deprecated: InvokeAsync has been deprecated
func (c *Lambda) InvokeAsyncRequest(input *InvokeAsyncInput) (req *request.Request, output *InvokeAsyncOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, InvokeAsync, has been deprecated")
	}
	op := &request.Operation{
		Name:       opInvokeAsync,
		HTTPMethod: "POST",
		HTTPPath:   "/2014-11-13/functions/{FunctionName}/invoke-async/",
	}

	if input == nil {
		input = &InvokeAsyncInput{}
	}

	output = &InvokeAsyncOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InvokeAsync API operation for AWS Lambda.
//
// For asynchronous function invocation, use Invoke.
//
// Submits an invocation request to AWS Lambda. Upon receiving the request,
// Lambda executes the specified function asynchronously. To see the logs generated
// by the Lambda function execution, see the CloudWatch Logs console.
//
// This operation requires permission for the lambda:InvokeFunction action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation InvokeAsync for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidRequestContentException "InvalidRequestContentException"
//   The request body could not be parsed as JSON.
//
//   * ErrCodeInvalidRuntimeException "InvalidRuntimeException"
//   The runtime or runtime version specified is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvokeAsync
//
// Deprecated: InvokeAsync has been deprecated
func (c *Lambda) InvokeAsync(input *InvokeAsyncInput) (*InvokeAsyncOutput, error) {
	req, out := c.InvokeAsyncRequest(input)
	return out, req.Send()
}

// InvokeAsyncWithContext is the same as InvokeAsync with the addition of
// the ability to pass a context and additional request options.
//
// See InvokeAsync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: InvokeAsyncWithContext has been deprecated
func (c *Lambda) InvokeAsyncWithContext(ctx aws.Context, input *InvokeAsyncInput, opts ...request.Option) (*InvokeAsyncOutput, error) {
	req, out := c.InvokeAsyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAliases for more information on using the ListAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAliasesRequest method.
//    req, resp := client.ListAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases
func (c *Lambda) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases",
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output = &ListAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAliases API operation for AWS Lambda.
//
// Returns list of aliases created for a Lambda function. For each alias, the
// response includes information such as the alias ARN, description, alias name,
// and the function version to which it points. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:ListAliases action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListAliases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases
func (c *Lambda) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	return out, req.Send()
}

// ListAliasesWithContext is the same as ListAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListAliasesWithContext(ctx aws.Context, input *ListAliasesInput, opts ...request.Option) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEventSourceMappings = "ListEventSourceMappings"

// ListEventSourceMappingsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventSourceMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventSourceMappings for more information on using the ListEventSourceMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEventSourceMappingsRequest method.
//    req, resp := client.ListEventSourceMappingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings
func (c *Lambda) ListEventSourceMappingsRequest(input *ListEventSourceMappingsInput) (req *request.Request, output *ListEventSourceMappingsOutput) {
	op := &request.Operation{
		Name:       opListEventSourceMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventSourceMappingsInput{}
	}

	output = &ListEventSourceMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventSourceMappings API operation for AWS Lambda.
//
// Lists event source mappings. Specify an EventSourceArn to only show event
// source mappings for a single event source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListEventSourceMappings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings
func (c *Lambda) ListEventSourceMappings(input *ListEventSourceMappingsInput) (*ListEventSourceMappingsOutput, error) {
	req, out := c.ListEventSourceMappingsRequest(input)
	return out, req.Send()
}

// ListEventSourceMappingsWithContext is the same as ListEventSourceMappings with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventSourceMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListEventSourceMappingsWithContext(ctx aws.Context, input *ListEventSourceMappingsInput, opts ...request.Option) (*ListEventSourceMappingsOutput, error) {
	req, out := c.ListEventSourceMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventSourceMappingsPages iterates over the pages of a ListEventSourceMappings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventSourceMappings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEventSourceMappings operation.
//    pageNum := 0
//    err := client.ListEventSourceMappingsPages(params,
//        func(page *ListEventSourceMappingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListEventSourceMappingsPages(input *ListEventSourceMappingsInput, fn func(*ListEventSourceMappingsOutput, bool) bool) error {
	return c.ListEventSourceMappingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventSourceMappingsPagesWithContext same as ListEventSourceMappingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListEventSourceMappingsPagesWithContext(ctx aws.Context, input *ListEventSourceMappingsInput, fn func(*ListEventSourceMappingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventSourceMappingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventSourceMappingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListEventSourceMappingsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListFunctions = "ListFunctions"

// ListFunctionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFunctions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFunctions for more information on using the ListFunctions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFunctionsRequest method.
//    req, resp := client.ListFunctionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions
func (c *Lambda) ListFunctionsRequest(input *ListFunctionsInput) (req *request.Request, output *ListFunctionsOutput) {
	op := &request.Operation{
		Name:       opListFunctions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFunctionsInput{}
	}

	output = &ListFunctionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFunctions API operation for AWS Lambda.
//
// Returns a list of your Lambda functions. For each function, the response
// includes the function configuration information. You must use GetFunction
// to retrieve the code for your function.
//
// This operation requires permission for the lambda:ListFunctions action.
//
// If you are using the versioning feature, you can list all of your functions
// or only $LATEST versions. For information about the versioning feature, see
// AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListFunctions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions
func (c *Lambda) ListFunctions(input *ListFunctionsInput) (*ListFunctionsOutput, error) {
	req, out := c.ListFunctionsRequest(input)
	return out, req.Send()
}

// ListFunctionsWithContext is the same as ListFunctions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFunctions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListFunctionsWithContext(ctx aws.Context, input *ListFunctionsInput, opts ...request.Option) (*ListFunctionsOutput, error) {
	req, out := c.ListFunctionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFunctionsPages iterates over the pages of a ListFunctions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFunctions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFunctions operation.
//    pageNum := 0
//    err := client.ListFunctionsPages(params,
//        func(page *ListFunctionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListFunctionsPages(input *ListFunctionsInput, fn func(*ListFunctionsOutput, bool) bool) error {
	return c.ListFunctionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFunctionsPagesWithContext same as ListFunctionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListFunctionsPagesWithContext(ctx aws.Context, input *ListFunctionsInput, fn func(*ListFunctionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFunctionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFunctionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListFunctionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListLayerVersions = "ListLayerVersions"

// ListLayerVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListLayerVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLayerVersions for more information on using the ListLayerVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLayerVersionsRequest method.
//    req, resp := client.ListLayerVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions
func (c *Lambda) ListLayerVersionsRequest(input *ListLayerVersionsInput) (req *request.Request, output *ListLayerVersionsOutput) {
	op := &request.Operation{
		Name:       opListLayerVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions",
	}

	if input == nil {
		input = &ListLayerVersionsInput{}
	}

	output = &ListLayerVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLayerVersions API operation for AWS Lambda.
//
// Lists the versions of a function layer. Versions that have been deleted aren't
// listed. Specify a runtime identifier (http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html)
// to list only versions that indicate that they're compatible with that runtime.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListLayerVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions
func (c *Lambda) ListLayerVersions(input *ListLayerVersionsInput) (*ListLayerVersionsOutput, error) {
	req, out := c.ListLayerVersionsRequest(input)
	return out, req.Send()
}

// ListLayerVersionsWithContext is the same as ListLayerVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListLayerVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListLayerVersionsWithContext(ctx aws.Context, input *ListLayerVersionsInput, opts ...request.Option) (*ListLayerVersionsOutput, error) {
	req, out := c.ListLayerVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLayers = "ListLayers"

// ListLayersRequest generates a "aws/request.Request" representing the
// client's request for the ListLayers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLayers for more information on using the ListLayers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLayersRequest method.
//    req, resp := client.ListLayersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers
func (c *Lambda) ListLayersRequest(input *ListLayersInput) (req *request.Request, output *ListLayersOutput) {
	op := &request.Operation{
		Name:       opListLayers,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-10-31/layers",
	}

	if input == nil {
		input = &ListLayersInput{}
	}

	output = &ListLayersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLayers API operation for AWS Lambda.
//
// Lists function layers and shows information about the latest version of each.
// Specify a runtime identifier (http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html)
// to list only layers that indicate that they're compatible with that runtime.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListLayers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers
func (c *Lambda) ListLayers(input *ListLayersInput) (*ListLayersOutput, error) {
	req, out := c.ListLayersRequest(input)
	return out, req.Send()
}

// ListLayersWithContext is the same as ListLayers with the addition of
// the ability to pass a context and additional request options.
//
// See ListLayers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListLayersWithContext(ctx aws.Context, input *ListLayersInput, opts ...request.Option) (*ListLayersOutput, error) {
	req, out := c.ListLayersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags
func (c *Lambda) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/2017-03-31/tags/{ARN}",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for AWS Lambda.
//
// Returns a list of tags assigned to a function when supplied the function
// ARN (Amazon Resource Name). For more information on Tagging, see Tagging
// Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
// in the AWS Lambda Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags
func (c *Lambda) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVersionsByFunction = "ListVersionsByFunction"

// ListVersionsByFunctionRequest generates a "aws/request.Request" representing the
// client's request for the ListVersionsByFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVersionsByFunction for more information on using the ListVersionsByFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVersionsByFunctionRequest method.
//    req, resp := client.ListVersionsByFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction
func (c *Lambda) ListVersionsByFunctionRequest(input *ListVersionsByFunctionInput) (req *request.Request, output *ListVersionsByFunctionOutput) {
	op := &request.Operation{
		Name:       opListVersionsByFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions",
	}

	if input == nil {
		input = &ListVersionsByFunctionInput{}
	}

	output = &ListVersionsByFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVersionsByFunction API operation for AWS Lambda.
//
// Lists all versions of a function. For information about versioning, see AWS
// Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListVersionsByFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction
func (c *Lambda) ListVersionsByFunction(input *ListVersionsByFunctionInput) (*ListVersionsByFunctionOutput, error) {
	req, out := c.ListVersionsByFunctionRequest(input)
	return out, req.Send()
}

// ListVersionsByFunctionWithContext is the same as ListVersionsByFunction with the addition of
// the ability to pass a context and additional request options.
//
// See ListVersionsByFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListVersionsByFunctionWithContext(ctx aws.Context, input *ListVersionsByFunctionInput, opts ...request.Option) (*ListVersionsByFunctionOutput, error) {
	req, out := c.ListVersionsByFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPublishLayerVersion = "PublishLayerVersion"

// PublishLayerVersionRequest generates a "aws/request.Request" representing the
// client's request for the PublishLayerVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PublishLayerVersion for more information on using the PublishLayerVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PublishLayerVersionRequest method.
//    req, resp := client.PublishLayerVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion
func (c *Lambda) PublishLayerVersionRequest(input *PublishLayerVersionInput) (req *request.Request, output *PublishLayerVersionOutput) {
	op := &request.Operation{
		Name:       opPublishLayerVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions",
	}

	if input == nil {
		input = &PublishLayerVersionInput{}
	}

	output = &PublishLayerVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PublishLayerVersion API operation for AWS Lambda.
//
// Creates a function layer from a ZIP archive. Each time you call PublishLayerVersion
// with the same version name, a new version is created.
//
// Add layers to your function with CreateFunction or UpdateFunctionConfiguration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation PublishLayerVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeCodeStorageExceededException "CodeStorageExceededException"
//   You have exceeded your maximum total code size per account. Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion
func (c *Lambda) PublishLayerVersion(input *PublishLayerVersionInput) (*PublishLayerVersionOutput, error) {
	req, out := c.PublishLayerVersionRequest(input)
	return out, req.Send()
}

// PublishLayerVersionWithContext is the same as PublishLayerVersion with the addition of
// the ability to pass a context and additional request options.
//
// See PublishLayerVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) PublishLayerVersionWithContext(ctx aws.Context, input *PublishLayerVersionInput, opts ...request.Option) (*PublishLayerVersionOutput, error) {
	req, out := c.PublishLayerVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPublishVersion = "PublishVersion"

// PublishVersionRequest generates a "aws/request.Request" representing the
// client's request for the PublishVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PublishVersion for more information on using the PublishVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PublishVersionRequest method.
//    req, resp := client.PublishVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion
func (c *Lambda) PublishVersionRequest(input *PublishVersionInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opPublishVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions",
	}

	if input == nil {
		input = &PublishVersionInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// PublishVersion API operation for AWS Lambda.
//
// Publishes a version of your function from the current snapshot of $LATEST.
// That is, AWS Lambda takes a snapshot of the function code and configuration
// information from $LATEST and publishes a new version. The code and configuration
// cannot be modified after publication. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation PublishVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeCodeStorageExceededException "CodeStorageExceededException"
//   You have exceeded your maximum total code size per account. Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
//   * ErrCodePreconditionFailedException "PreconditionFailedException"
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion
func (c *Lambda) PublishVersion(input *PublishVersionInput) (*FunctionConfiguration, error) {
	req, out := c.PublishVersionRequest(input)
	return out, req.Send()
}

// PublishVersionWithContext is the same as PublishVersion with the addition of
// the ability to pass a context and additional request options.
//
// See PublishVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) PublishVersionWithContext(ctx aws.Context, input *PublishVersionInput, opts ...request.Option) (*FunctionConfiguration, error) {
	req, out := c.PublishVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutFunctionConcurrency = "PutFunctionConcurrency"

// PutFunctionConcurrencyRequest generates a "aws/request.Request" representing the
// client's request for the PutFunctionConcurrency operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFunctionConcurrency for more information on using the PutFunctionConcurrency
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutFunctionConcurrencyRequest method.
//    req, resp := client.PutFunctionConcurrencyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency
func (c *Lambda) PutFunctionConcurrencyRequest(input *PutFunctionConcurrencyInput) (req *request.Request, output *PutFunctionConcurrencyOutput) {
	op := &request.Operation{
		Name:       opPutFunctionConcurrency,
		HTTPMethod: "PUT",
		HTTPPath:   "/2017-10-31/functions/{FunctionName}/concurrency",
	}

	if input == nil {
		input = &PutFunctionConcurrencyInput{}
	}

	output = &PutFunctionConcurrencyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutFunctionConcurrency API operation for AWS Lambda.
//
// Sets a limit on the number of concurrent executions available to this function.
// It is a subset of your account's total concurrent execution limit per region.
// Note that Lambda automatically reserves a buffer of 100 concurrent executions
// for functions without any reserved concurrency limit. This means if your
// account limit is 1000, you have a total of 900 available to allocate to individual
// functions. For more information, see Managing Concurrency (http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation PutFunctionConcurrency for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency
func (c *Lambda) PutFunctionConcurrency(input *PutFunctionConcurrencyInput) (*PutFunctionConcurrencyOutput, error) {
	req, out := c.PutFunctionConcurrencyRequest(input)
	return out, req.Send()
}

// PutFunctionConcurrencyWithContext is the same as PutFunctionConcurrency with the addition of
// the ability to pass a context and additional request options.
//
// See PutFunctionConcurrency for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) PutFunctionConcurrencyWithContext(ctx aws.Context, input *PutFunctionConcurrencyInput, opts ...request.Option) (*PutFunctionConcurrencyOutput, error) {
	req, out := c.PutFunctionConcurrencyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveLayerVersionPermission = "RemoveLayerVersionPermission"

// RemoveLayerVersionPermissionRequest generates a "aws/request.Request" representing the
// client's request for the RemoveLayerVersionPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveLayerVersionPermission for more information on using the RemoveLayerVersionPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveLayerVersionPermissionRequest method.
//    req, resp := client.RemoveLayerVersionPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission
func (c *Lambda) RemoveLayerVersionPermissionRequest(input *RemoveLayerVersionPermissionInput) (req *request.Request, output *RemoveLayerVersionPermissionOutput) {
	op := &request.Operation{
		Name:       opRemoveLayerVersionPermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy/{StatementId}",
	}

	if input == nil {
		input = &RemoveLayerVersionPermissionInput{}
	}

	output = &RemoveLayerVersionPermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveLayerVersionPermission API operation for AWS Lambda.
//
// Removes a statement from the permissions policy for a layer version. For
// more information, see AddLayerVersionPermission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation RemoveLayerVersionPermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodePreconditionFailedException "PreconditionFailedException"
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission
func (c *Lambda) RemoveLayerVersionPermission(input *RemoveLayerVersionPermissionInput) (*RemoveLayerVersionPermissionOutput, error) {
	req, out := c.RemoveLayerVersionPermissionRequest(input)
	return out, req.Send()
}

// RemoveLayerVersionPermissionWithContext is the same as RemoveLayerVersionPermission with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveLayerVersionPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) RemoveLayerVersionPermissionWithContext(ctx aws.Context, input *RemoveLayerVersionPermissionInput, opts ...request.Option) (*RemoveLayerVersionPermissionOutput, error) {
	req, out := c.RemoveLayerVersionPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest generates a "aws/request.Request" representing the
// client's request for the RemovePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemovePermission for more information on using the RemovePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemovePermissionRequest method.
//    req, resp := client.RemovePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission
func (c *Lambda) RemovePermissionRequest(input *RemovePermissionInput) (req *request.Request, output *RemovePermissionOutput) {
	op := &request.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy/{StatementId}",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	output = &RemovePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemovePermission API operation for AWS Lambda.
//
// Removes permissions from a function. You can remove individual permissions
// from an resource policy associated with a Lambda function by providing a
// statement ID that you provided when you added the permission. When you remove
// permissions, disable the event source mapping or trigger configuration first
// to avoid errors.
//
// Permissions apply to the Amazon Resource Name (ARN) used to invoke the function,
// which can be unqualified (the unpublished version of the function), or include
// a version or alias. If a client uses a version or alias to invoke a function,
// use the Qualifier parameter to apply permissions to that ARN. For more information
// about versioning, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// You need permission for the lambda:RemovePermission action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation RemovePermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodePreconditionFailedException "PreconditionFailedException"
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission
func (c *Lambda) RemovePermission(input *RemovePermissionInput) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	return out, req.Send()
}

// RemovePermissionWithContext is the same as RemovePermission with the addition of
// the ability to pass a context and additional request options.
//
// See RemovePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) RemovePermissionWithContext(ctx aws.Context, input *RemovePermissionInput, opts ...request.Option) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource
func (c *Lambda) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2017-03-31/tags/{ARN}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Lambda.
//
// Creates a list of tags (key-value pairs) on the Lambda function. Requires
// the Lambda function ARN (Amazon Resource Name). If a key is specified without
// a value, Lambda creates a tag with the specified key and a value of null.
// For more information, see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
// in the AWS Lambda Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource
func (c *Lambda) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource
func (c *Lambda) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2017-03-31/tags/{ARN}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Lambda.
//
// Removes tags from a Lambda function. Requires the function ARN (Amazon Resource
// Name). For more information, see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
// in the AWS Lambda Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource
func (c *Lambda) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAlias for more information on using the UpdateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAliasRequest method.
//    req, resp := client.UpdateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias
func (c *Lambda) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	output = &AliasConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAlias API operation for AWS Lambda.
//
// Using this API you can update the function version to which the alias points
// and the alias description. For more information, see Introduction to AWS
// Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:UpdateAlias action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodePreconditionFailedException "PreconditionFailedException"
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias
func (c *Lambda) UpdateAlias(input *UpdateAliasInput) (*AliasConfiguration, error) {
	req, out := c.UpdateAliasRequest(input)
	return out, req.Send()
}

// UpdateAliasWithContext is the same as UpdateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UpdateAliasWithContext(ctx aws.Context, input *UpdateAliasInput, opts ...request.Option) (*AliasConfiguration, error) {
	req, out := c.UpdateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventSourceMapping = "UpdateEventSourceMapping"

// UpdateEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventSourceMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventSourceMapping for more information on using the UpdateEventSourceMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEventSourceMappingRequest method.
//    req, resp := client.UpdateEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping
func (c *Lambda) UpdateEventSourceMappingRequest(input *UpdateEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opUpdateEventSourceMapping,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &UpdateEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEventSourceMapping API operation for AWS Lambda.
//
// Updates an event source mapping. You can change the function that AWS Lambda
// invokes, or pause invocation and resume later from the same location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateEventSourceMapping for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to update an EventSoure Mapping in CREATING, or tried to delete
//   a EventSoure mapping currently in the UPDATING state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping
func (c *Lambda) UpdateEventSourceMapping(input *UpdateEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.UpdateEventSourceMappingRequest(input)
	return out, req.Send()
}

// UpdateEventSourceMappingWithContext is the same as UpdateEventSourceMapping with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventSourceMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UpdateEventSourceMappingWithContext(ctx aws.Context, input *UpdateEventSourceMappingInput, opts ...request.Option) (*EventSourceMappingConfiguration, error) {
	req, out := c.UpdateEventSourceMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFunctionCode = "UpdateFunctionCode"

// UpdateFunctionCodeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFunctionCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFunctionCode for more information on using the UpdateFunctionCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFunctionCodeRequest method.
//    req, resp := client.UpdateFunctionCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode
func (c *Lambda) UpdateFunctionCodeRequest(input *UpdateFunctionCodeInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opUpdateFunctionCode,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/code",
	}

	if input == nil {
		input = &UpdateFunctionCodeInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFunctionCode API operation for AWS Lambda.
//
// Updates the code for the specified Lambda function. This operation must only
// be used on an existing Lambda function and cannot be used to update the function
// configuration.
//
// If you are using the versioning feature, note this API will always update
// the $LATEST version of your Lambda function. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:UpdateFunctionCode action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateFunctionCode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeCodeStorageExceededException "CodeStorageExceededException"
//   You have exceeded your maximum total code size per account. Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
//   * ErrCodePreconditionFailedException "PreconditionFailedException"
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode
func (c *Lambda) UpdateFunctionCode(input *UpdateFunctionCodeInput) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionCodeRequest(input)
	return out, req.Send()
}

// UpdateFunctionCodeWithContext is the same as UpdateFunctionCode with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFunctionCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UpdateFunctionCodeWithContext(ctx aws.Context, input *UpdateFunctionCodeInput, opts ...request.Option) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFunctionConfiguration = "UpdateFunctionConfiguration"

// UpdateFunctionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFunctionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFunctionConfiguration for more information on using the UpdateFunctionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFunctionConfigurationRequest method.
//    req, resp := client.UpdateFunctionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration
func (c *Lambda) UpdateFunctionConfigurationRequest(input *UpdateFunctionConfigurationInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opUpdateFunctionConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/configuration",
	}

	if input == nil {
		input = &UpdateFunctionConfigurationInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFunctionConfiguration API operation for AWS Lambda.
//
// Updates the configuration parameters for the specified Lambda function by
// using the values provided in the request. You provide only the parameters
// you want to change. This operation must only be used on an existing Lambda
// function and cannot be used to update the function's code.
//
// If you are using the versioning feature, note this API will always update
// the $LATEST version of your Lambda function. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:UpdateFunctionConfiguration
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateFunctionConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Request throughput limit exceeded
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodePreconditionFailedException "PreconditionFailedException"
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration
func (c *Lambda) UpdateFunctionConfiguration(input *UpdateFunctionConfigurationInput) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionConfigurationRequest(input)
	return out, req.Send()
}

// UpdateFunctionConfigurationWithContext is the same as UpdateFunctionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFunctionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UpdateFunctionConfigurationWithContext(ctx aws.Context, input *UpdateFunctionConfigurationInput, opts ...request.Option) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Provides limits of code size and concurrency associated with the current
// account and region. For more information or to request a limit increase for
// concurrent executions, see Lambda Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html).
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// Size, in bytes, of code/dependencies that you can zip into a deployment package
	// (uncompressed zip/jar size) for uploading. The default limit is 250 MB.
	CodeSizeUnzipped *int64 `type:"long"`

	// Size, in bytes, of a single zipped code/dependencies package you can upload
	// for your Lambda function(.zip/.jar file). Try using Amazon S3 for uploading
	// larger files. Default limit is 50 MB.
	CodeSizeZipped *int64 `type:"long"`

	// Number of simultaneous executions of your function per region. The default
	// limit is 1000.
	ConcurrentExecutions *int64 `type:"integer"`

	// Maximum size, in bytes, of a code package you can upload per region. The
	// default size is 75 GB.
	TotalCodeSize *int64 `type:"long"`

	// The number of concurrent executions available to functions that do not have
	// concurrency limits set. For more information, see Managing Concurrency (http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
	UnreservedConcurrentExecutions *int64 `type:"integer"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLimit) GoString() string {
	return s.String()
}

// SetCodeSizeUnzipped sets the CodeSizeUnzipped field's value.
func (s *AccountLimit) SetCodeSizeUnzipped(v int64) *AccountLimit {
	s.CodeSizeUnzipped = &v
	return s
}

// SetCodeSizeZipped sets the CodeSizeZipped field's value.
func (s *AccountLimit) SetCodeSizeZipped(v int64) *AccountLimit {
	s.CodeSizeZipped = &v
	return s
}

// SetConcurrentExecutions sets the ConcurrentExecutions field's value.
func (s *AccountLimit) SetConcurrentExecutions(v int64) *AccountLimit {
	s.ConcurrentExecutions = &v
	return s
}

// SetTotalCodeSize sets the TotalCodeSize field's value.
func (s *AccountLimit) SetTotalCodeSize(v int64) *AccountLimit {
	s.TotalCodeSize = &v
	return s
}

// SetUnreservedConcurrentExecutions sets the UnreservedConcurrentExecutions field's value.
func (s *AccountLimit) SetUnreservedConcurrentExecutions(v int64) *AccountLimit {
	s.UnreservedConcurrentExecutions = &v
	return s
}

// Provides code size usage and function count associated with the current account
// and region.
type AccountUsage struct {
	_ struct{} `type:"structure"`

	// The number of your account's existing functions per region.
	FunctionCount *int64 `type:"long"`

	// Total size, in bytes, of the account's deployment packages per region.
	TotalCodeSize *int64 `type:"long"`
}

// String returns the string representation
func (s AccountUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountUsage) GoString() string {
	return s.String()
}

// SetFunctionCount sets the FunctionCount field's value.
func (s *AccountUsage) SetFunctionCount(v int64) *AccountUsage {
	s.FunctionCount = &v
	return s
}

// SetTotalCodeSize sets the TotalCodeSize field's value.
func (s *AccountUsage) SetTotalCodeSize(v int64) *AccountUsage {
	s.TotalCodeSize = &v
	return s
}

type AddLayerVersionPermissionInput struct {
	_ struct{} `type:"structure"`

	// The API action that grants access to the layer. For example, lambda:GetLayerVersion.
	//
	// Action is a required field
	Action *string `type:"string" required:"true"`

	// The name of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// With the principal set to *, grant permission to all accounts in the specified
	// organization.
	OrganizationId *string `type:"string"`

	// An account ID, or * to grant permission to all AWS accounts.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// Only update the policy if the revision ID matches the ID specified. Use this
	// option to avoid modifying a policy that has changed since you last read it.
	RevisionId *string `location:"querystring" locationName:"RevisionId" type:"string"`

	// An identifier that distinguishes the policy from others on the same layer
	// version.
	//
	// StatementId is a required field
	StatementId *string `min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s AddLayerVersionPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddLayerVersionPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddLayerVersionPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddLayerVersionPermissionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *AddLayerVersionPermissionInput) SetAction(v string) *AddLayerVersionPermissionInput {
	s.Action = &v
	return s
}

// SetLayerName sets the LayerName field's value.
func (s *AddLayerVersionPermissionInput) SetLayerName(v string) *AddLayerVersionPermissionInput {
	s.LayerName = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *AddLayerVersionPermissionInput) SetOrganizationId(v string) *AddLayerVersionPermissionInput {
	s.OrganizationId = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AddLayerVersionPermissionInput) SetPrincipal(v string) *AddLayerVersionPermissionInput {
	s.Principal = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AddLayerVersionPermissionInput) SetRevisionId(v string) *AddLayerVersionPermissionInput {
	s.RevisionId = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *AddLayerVersionPermissionInput) SetStatementId(v string) *AddLayerVersionPermissionInput {
	s.StatementId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *AddLayerVersionPermissionInput) SetVersionNumber(v int64) *AddLayerVersionPermissionInput {
	s.VersionNumber = &v
	return s
}

type AddLayerVersionPermissionOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the current revision of the policy.
	RevisionId *string `type:"string"`

	// The permission statement.
	Statement *string `type:"string"`
}

// String returns the string representation
func (s AddLayerVersionPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddLayerVersionPermissionOutput) GoString() string {
	return s.String()
}

// SetRevisionId sets the RevisionId field's value.
func (s *AddLayerVersionPermissionOutput) SetRevisionId(v string) *AddLayerVersionPermissionOutput {
	s.RevisionId = &v
	return s
}

// SetStatement sets the Statement field's value.
func (s *AddLayerVersionPermissionOutput) SetStatement(v string) *AddLayerVersionPermissionOutput {
	s.Statement = &v
	return s
}

type AddPermissionInput struct {
	_ struct{} `type:"structure"`

	// The AWS Lambda action you want to allow in this statement. Each Lambda action
	// is a string starting with lambda: followed by the API name . For example,
	// lambda:CreateFunction. You can use wildcard (lambda:*) to grant permission
	// for all AWS Lambda actions.
	//
	// Action is a required field
	Action *string `type:"string" required:"true"`

	// A unique token that must be supplied by the principal invoking the function.
	// This is currently only used for Alexa Smart Home functions.
	EventSourceToken *string `type:"string"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The principal who is getting this permission. The principal can be an AWS
	// service (e.g. s3.amazonaws.com or sns.amazonaws.com) for service triggers,
	// or an account ID for cross-account access. If you specify a service as a
	// principal, use the SourceArn parameter to limit who can invoke the function
	// through that service.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// Specify a version or alias to add permissions to a published version of the
	// function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you to retrieve the latest function version or alias RevisionID
	// using either GetFunction or GetAlias
	RevisionId *string `type:"string"`

	// This parameter is used for S3 and SES. The AWS account ID (without a hyphen)
	// of the source owner. For example, if the SourceArn identifies a bucket, then
	// this is the bucket owner's account ID. You can use this additional condition
	// to ensure the bucket you specify is owned by a specific account (it is possible
	// the bucket owner deleted the bucket and some other AWS account created the
	// bucket). You can also use this condition to specify all sources (that is,
	// you don't specify the SourceArn) owned by a specific account.
	SourceAccount *string `type:"string"`

	// The Amazon Resource Name of the invoker.
	//
	// If you add a permission to a service principal without providing the source
	// ARN, any AWS account that creates a mapping to your function ARN can invoke
	// your Lambda function.
	SourceArn *string `type:"string"`

	// A unique statement identifier.
	//
	// StatementId is a required field
	StatementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddPermissionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *AddPermissionInput) SetAction(v string) *AddPermissionInput {
	s.Action = &v
	return s
}

// SetEventSourceToken sets the EventSourceToken field's value.
func (s *AddPermissionInput) SetEventSourceToken(v string) *AddPermissionInput {
	s.EventSourceToken = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *AddPermissionInput) SetFunctionName(v string) *AddPermissionInput {
	s.FunctionName = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AddPermissionInput) SetPrincipal(v string) *AddPermissionInput {
	s.Principal = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *AddPermissionInput) SetQualifier(v string) *AddPermissionInput {
	s.Qualifier = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AddPermissionInput) SetRevisionId(v string) *AddPermissionInput {
	s.RevisionId = &v
	return s
}

// SetSourceAccount sets the SourceAccount field's value.
func (s *AddPermissionInput) SetSourceAccount(v string) *AddPermissionInput {
	s.SourceAccount = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *AddPermissionInput) SetSourceArn(v string) *AddPermissionInput {
	s.SourceArn = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *AddPermissionInput) SetStatementId(v string) *AddPermissionInput {
	s.StatementId = &v
	return s
}

type AddPermissionOutput struct {
	_ struct{} `type:"structure"`

	// The permission statement you specified in the request. The response returns
	// the same as a string using a backslash ("\") as an escape character in the
	// JSON.
	Statement *string `type:"string"`
}

// String returns the string representation
func (s AddPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionOutput) GoString() string {
	return s.String()
}

// SetStatement sets the Statement field's value.
func (s *AddPermissionOutput) SetStatement(v string) *AddPermissionOutput {
	s.Statement = &v
	return s
}

// Provides configuration information about a Lambda function version alias.
type AliasConfiguration struct {
	_ struct{} `type:"structure"`

	// Lambda function ARN that is qualified using the alias name as the suffix.
	// For example, if you create an alias called BETA that points to a helloworld
	// function version, the ARN is arn:aws:lambda:aws-regions:acct-id:function:helloworld:BETA.
	AliasArn *string `type:"string"`

	// Alias description.
	Description *string `type:"string"`

	// Function version to which the alias points.
	FunctionVersion *string `min:"1" type:"string"`

	// Alias name.
	Name *string `min:"1" type:"string"`

	// Represents the latest updated revision of the function or alias.
	RevisionId *string `type:"string"`

	// Specifies an additional function versions the alias points to, allowing you
	// to dictate what percentage of traffic will invoke each version.
	RoutingConfig *AliasRoutingConfiguration `type:"structure"`
}

// String returns the string representation
func (s AliasConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasConfiguration) GoString() string {
	return s.String()
}

// SetAliasArn sets the AliasArn field's value.
func (s *AliasConfiguration) SetAliasArn(v string) *AliasConfiguration {
	s.AliasArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AliasConfiguration) SetDescription(v string) *AliasConfiguration {
	s.Description = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *AliasConfiguration) SetFunctionVersion(v string) *AliasConfiguration {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *AliasConfiguration) SetName(v string) *AliasConfiguration {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AliasConfiguration) SetRevisionId(v string) *AliasConfiguration {
	s.RevisionId = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *AliasConfiguration) SetRoutingConfig(v *AliasRoutingConfiguration) *AliasConfiguration {
	s.RoutingConfig = v
	return s
}

// The alias's traffic shifting (http://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
// configuration.
type AliasRoutingConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the second alias, and the percentage of traffic that is routed
	// to it.
	AdditionalVersionWeights map[string]*float64 `type:"map"`
}

// String returns the string representation
func (s AliasRoutingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasRoutingConfiguration) GoString() string {
	return s.String()
}

// SetAdditionalVersionWeights sets the AdditionalVersionWeights field's value.
func (s *AliasRoutingConfiguration) SetAdditionalVersionWeights(v map[string]*float64) *AliasRoutingConfiguration {
	s.AdditionalVersionWeights = v
	return s
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// Description of the alias.
	Description *string `type:"string"`

	// The name of the lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Lambda function version for which you are creating the alias.
	//
	// FunctionVersion is a required field
	FunctionVersion *string `min:"1" type:"string" required:"true"`

	// Name for the alias you are creating.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies an additional version your alias can point to, allowing you to
	// dictate what percentage of traffic will invoke each version. For more information,
	// see Traffic Shifting Using Aliases (http://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html).
	RoutingConfig *AliasRoutingConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionVersion"))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAliasInput) SetDescription(v string) *CreateAliasInput {
	s.Description = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *CreateAliasInput) SetFunctionName(v string) *CreateAliasInput {
	s.FunctionName = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *CreateAliasInput) SetFunctionVersion(v string) *CreateAliasInput {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAliasInput) SetName(v string) *CreateAliasInput {
	s.Name = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *CreateAliasInput) SetRoutingConfig(v *AliasRoutingConfiguration) *CreateAliasInput {
	s.RoutingConfig = v
	return s
}

type CreateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	//
	//    * Amazon Kinesis - Default 100. Max 10,000.
	//
	//    * Amazon DynamoDB Streams - Default 100. Max 1,000.
	//
	//    * Amazon Simple Queue Service - Default 10. Max 10.
	BatchSize *int64 `min:"1" type:"integer"`

	// Disables the event source mapping to pause polling and invocation.
	Enabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the event source.
	//
	//    * Amazon Kinesis - The ARN of the data stream or a stream consumer.
	//
	//    * Amazon DynamoDB Streams - The ARN of the stream.
	//
	//    * Amazon Simple Queue Service - The ARN of the queue.
	//
	// EventSourceArn is a required field
	EventSourceArn *string `type:"string" required:"true"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Version or Alias ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it's limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The position in a stream from which to start reading. Required for Amazon
	// Kinesis and Amazon DynamoDB Streams sources. AT_TIMESTAMP is only supported
	// for Amazon Kinesis streams.
	StartingPosition *string `type:"string" enum:"EventSourcePosition"`

	// With StartingPosition set to AT_TIMESTAMP, the Unix time in seconds from
	// which to start reading.
	StartingPositionTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CreateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSourceMappingInput"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.EventSourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EventSourceArn"))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *CreateEventSourceMappingInput) SetBatchSize(v int64) *CreateEventSourceMappingInput {
	s.BatchSize = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSourceMappingInput) SetEnabled(v bool) *CreateEventSourceMappingInput {
	s.Enabled = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *CreateEventSourceMappingInput) SetEventSourceArn(v string) *CreateEventSourceMappingInput {
	s.EventSourceArn = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *CreateEventSourceMappingInput) SetFunctionName(v string) *CreateEventSourceMappingInput {
	s.FunctionName = &v
	return s
}

// SetStartingPosition sets the StartingPosition field's value.
func (s *CreateEventSourceMappingInput) SetStartingPosition(v string) *CreateEventSourceMappingInput {
	s.StartingPosition = &v
	return s
}

// SetStartingPositionTimestamp sets the StartingPositionTimestamp field's value.
func (s *CreateEventSourceMappingInput) SetStartingPositionTimestamp(v time.Time) *CreateEventSourceMappingInput {
	s.StartingPositionTimestamp = &v
	return s
}

type CreateFunctionInput struct {
	_ struct{} `type:"structure"`

	// The code for the function.
	//
	// Code is a required field
	Code *FunctionCode `type:"structure" required:"true"`

	// A dead letter queue configuration that specifies the queue or topic where
	// Lambda sends asynchronous events when they fail processing. For more information,
	// see Dead Letter Queues (http://docs.aws.amazon.com/lambda/latest/dg/dlq.html).
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// A description of the function.
	Description *string `type:"string"`

	// Environment variables that are accessible from function code during execution.
	Environment *Environment `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The name of the method within your code that Lambda calls to execute your
	// function. For more information, see Programming Model (http://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html).
	//
	// Handler is a required field
	Handler *string `type:"string" required:"true"`

	// The ARN of the KMS key used to encrypt your function's environment variables.
	// If not provided, AWS Lambda will use a default service key.
	KMSKeyArn *string `type:"string"`

	// A list of function layers (http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
	// to add to the function's execution environment.
	Layers []*string `type:"list"`

	// The amount of memory that your function has access to. Increasing the function's
	// memory also increases it's CPU allocation. The default value is 128 MB. The
	// value must be a multiple of 64 MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// Set to true to publish the first version of the function during creation.
	Publish *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the function's execution role (http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role).
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// The runtime version for the function.
	//
	// Runtime is a required field
	Runtime *string `type:"string" required:"true" enum:"Runtime"`

	// The list of tags (key-value pairs) assigned to the new function. For more
	// information, see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	Tags map[string]*string `type:"map"`

	// The amount of time that Lambda allows a function to run before terminating
	// it. The default is 3 seconds. The maximum allowed value is 900 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// Set Mode to Active to sample and trace a subset of incoming requests with
	// AWS X-Ray.
	TracingConfig *TracingConfig `type:"structure"`

	// If your Lambda function accesses resources in a VPC, you provide this parameter
	// identifying the list of security group IDs and subnet IDs. These must belong
	// to the same VPC. You must provide at least one security group and one subnet
	// ID.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFunctionInput"}
	if s.Code == nil {
		invalidParams.Add(request.NewErrParamRequired("Code"))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Handler == nil {
		invalidParams.Add(request.NewErrParamRequired("Handler"))
	}
	if s.MemorySize != nil && *s.MemorySize < 128 {
		invalidParams.Add(request.NewErrParamMinValue("MemorySize", 128))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Runtime == nil {
		invalidParams.Add(request.NewErrParamRequired("Runtime"))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}
	if s.Code != nil {
		if err := s.Code.Validate(); err != nil {
			invalidParams.AddNested("Code", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCode sets the Code field's value.
func (s *CreateFunctionInput) SetCode(v *FunctionCode) *CreateFunctionInput {
	s.Code = v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *CreateFunctionInput) SetDeadLetterConfig(v *DeadLetterConfig) *CreateFunctionInput {
	s.DeadLetterConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFunctionInput) SetDescription(v string) *CreateFunctionInput {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *CreateFunctionInput) SetEnvironment(v *Environment) *CreateFunctionInput {
	s.Environment = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *CreateFunctionInput) SetFunctionName(v string) *CreateFunctionInput {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *CreateFunctionInput) SetHandler(v string) *CreateFunctionInput {
	s.Handler = &v
	return s
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *CreateFunctionInput) SetKMSKeyArn(v string) *CreateFunctionInput {
	s.KMSKeyArn = &v
	return s
}

// SetLayers sets the Layers field's value.
func (s *CreateFunctionInput) SetLayers(v []*string) *CreateFunctionInput {
	s.Layers = v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *CreateFunctionInput) SetMemorySize(v int64) *CreateFunctionInput {
	s.MemorySize = &v
	return s
}

// SetPublish sets the Publish field's value.
func (s *CreateFunctionInput) SetPublish(v bool) *CreateFunctionInput {
	s.Publish = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateFunctionInput) SetRole(v string) *CreateFunctionInput {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *CreateFunctionInput) SetRuntime(v string) *CreateFunctionInput {
	s.Runtime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFunctionInput) SetTags(v map[string]*string) *CreateFunctionInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *CreateFunctionInput) SetTimeout(v int64) *CreateFunctionInput {
	s.Timeout = &v
	return s
}

// SetTracingConfig sets the TracingConfig field's value.
func (s *CreateFunctionInput) SetTracingConfig(v *TracingConfig) *CreateFunctionInput {
	s.TracingConfig = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateFunctionInput) SetVpcConfig(v *VpcConfig) *CreateFunctionInput {
	s.VpcConfig = v
	return s
}

// The dead letter queue (http://docs.aws.amazon.com/lambda/latest/dg/dlq.html)
// for failed asynchronous invocations.
type DeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.
	TargetArn *string `type:"string"`
}

// String returns the string representation
func (s DeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeadLetterConfig) GoString() string {
	return s.String()
}

// SetTargetArn sets the TargetArn field's value.
func (s *DeadLetterConfig) SetTargetArn(v string) *DeadLetterConfig {
	s.TargetArn = &v
	return s
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Name of the alias to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteAliasInput) SetFunctionName(v string) *DeleteAliasInput {
	s.FunctionName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAliasInput) SetName(v string) *DeleteAliasInput {
	s.Name = &v
	return s
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DeleteEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the event source mapping.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSourceMappingInput"}
	if s.UUID == nil {
		invalidParams.Add(request.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUUID sets the UUID field's value.
func (s *DeleteEventSourceMappingInput) SetUUID(v string) *DeleteEventSourceMappingInput {
	s.UUID = &v
	return s
}

type DeleteFunctionConcurrencyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFunctionConcurrencyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionConcurrencyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionConcurrencyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFunctionConcurrencyInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteFunctionConcurrencyInput) SetFunctionName(v string) *DeleteFunctionConcurrencyInput {
	s.FunctionName = &v
	return s
}

type DeleteFunctionConcurrencyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionConcurrencyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionConcurrencyOutput) GoString() string {
	return s.String()
}

type DeleteFunctionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify a version to delete. You cannot delete a version that is referenced
	// by an alias.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFunctionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteFunctionInput) SetFunctionName(v string) *DeleteFunctionInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *DeleteFunctionInput) SetQualifier(v string) *DeleteFunctionInput {
	s.Qualifier = &v
	return s
}

type DeleteFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionOutput) GoString() string {
	return s.String()
}

type DeleteLayerVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s DeleteLayerVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLayerVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLayerVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLayerVersionInput"}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerName sets the LayerName field's value.
func (s *DeleteLayerVersionInput) SetLayerName(v string) *DeleteLayerVersionInput {
	s.LayerName = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DeleteLayerVersionInput) SetVersionNumber(v int64) *DeleteLayerVersionInput {
	s.VersionNumber = &v
	return s
}

type DeleteLayerVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLayerVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLayerVersionOutput) GoString() string {
	return s.String()
}

// A function's environment variable settings.
type Environment struct {
	_ struct{} `type:"structure"`

	// Environment variable key-value pairs.
	Variables map[string]*string `type:"map"`
}

// String returns the string representation
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Environment) GoString() string {
	return s.String()
}

// SetVariables sets the Variables field's value.
func (s *Environment) SetVariables(v map[string]*string) *Environment {
	s.Variables = v
	return s
}

// Error messages for environment variables that could not be applied.
type EnvironmentError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	Message *string `type:"string"`
}

// String returns the string representation
func (s EnvironmentError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *EnvironmentError) SetErrorCode(v string) *EnvironmentError {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EnvironmentError) SetMessage(v string) *EnvironmentError {
	s.Message = &v
	return s
}

// The results of a configuration update that applied environment variables.
type EnvironmentResponse struct {
	_ struct{} `type:"structure"`

	// Error messages for environment variables that could not be applied.
	Error *EnvironmentError `type:"structure"`

	// Environment variable key-value pairs.
	Variables map[string]*string `type:"map"`
}

// String returns the string representation
func (s EnvironmentResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentResponse) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *EnvironmentResponse) SetError(v *EnvironmentError) *EnvironmentResponse {
	s.Error = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *EnvironmentResponse) SetVariables(v map[string]*string) *EnvironmentResponse {
	s.Variables = v
	return s
}

// A mapping between an AWS resource and an AWS Lambda function. See CreateEventSourceMapping
// for details.
type EventSourceMappingConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the event source.
	EventSourceArn *string `type:"string"`

	// The ARN of the Lambda function.
	FunctionArn *string `type:"string"`

	// The date that the event source mapping was last updated, in Unix time seconds.
	LastModified *time.Time `type:"timestamp"`

	// The result of the last AWS Lambda invocation of your Lambda function.
	LastProcessingResult *string `type:"string"`

	// The state of the event source mapping. It can be one of the following: Creating,
	// Enabling, Enabled, Disabling, Disabled, Updating, or Deleting.
	State *string `type:"string"`

	// The cause of the last state change, either User initiated or Lambda initiated.
	StateTransitionReason *string `type:"string"`

	// The identifier of the event source mapping.
	UUID *string `type:"string"`
}

// String returns the string representation
func (s EventSourceMappingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSourceMappingConfiguration) GoString() string {
	return s.String()
}

// SetBatchSize sets the BatchSize field's value.
func (s *EventSourceMappingConfiguration) SetBatchSize(v int64) *EventSourceMappingConfiguration {
	s.BatchSize = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *EventSourceMappingConfiguration) SetEventSourceArn(v string) *EventSourceMappingConfiguration {
	s.EventSourceArn = &v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *EventSourceMappingConfiguration) SetFunctionArn(v string) *EventSourceMappingConfiguration {
	s.FunctionArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *EventSourceMappingConfiguration) SetLastModified(v time.Time) *EventSourceMappingConfiguration {
	s.LastModified = &v
	return s
}

// SetLastProcessingResult sets the LastProcessingResult field's value.
func (s *EventSourceMappingConfiguration) SetLastProcessingResult(v string) *EventSourceMappingConfiguration {
	s.LastProcessingResult = &v
	return s
}

// SetState sets the State field's value.
func (s *EventSourceMappingConfiguration) SetState(v string) *EventSourceMappingConfiguration {
	s.State = &v
	return s
}

// SetStateTransitionReason sets the StateTransitionReason field's value.
func (s *EventSourceMappingConfiguration) SetStateTransitionReason(v string) *EventSourceMappingConfiguration {
	s.StateTransitionReason = &v
	return s
}

// SetUUID sets the UUID field's value.
func (s *EventSourceMappingConfiguration) SetUUID(v string) *EventSourceMappingConfiguration {
	s.UUID = &v
	return s
}

// The code for the Lambda function. You can specify either an S3 location,
// or upload a deployment package directly.
type FunctionCode struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 bucket in the same region as your function.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 key of the deployment package.
	S3Key *string `min:"1" type:"string"`

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The base64-encoded contents of your zip file containing your deployment package.
	// AWS SDK and AWS CLI clients handle the encoding for you.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s FunctionCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionCode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FunctionCode"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *FunctionCode) SetS3Bucket(v string) *FunctionCode {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *FunctionCode) SetS3Key(v string) *FunctionCode {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *FunctionCode) SetS3ObjectVersion(v string) *FunctionCode {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *FunctionCode) SetZipFile(v []byte) *FunctionCode {
	s.ZipFile = v
	return s
}

// The object for the Lambda function location.
type FunctionCodeLocation struct {
	_ struct{} `type:"structure"`

	// The presigned URL you can use to download the function's .zip file that you
	// previously uploaded. The URL is valid for up to 10 minutes.
	Location *string `type:"string"`

	// The repository from which you can download the function.
	RepositoryType *string `type:"string"`
}

// String returns the string representation
func (s FunctionCodeLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCodeLocation) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *FunctionCodeLocation) SetLocation(v string) *FunctionCodeLocation {
	s.Location = &v
	return s
}

// SetRepositoryType sets the RepositoryType field's value.
func (s *FunctionCodeLocation) SetRepositoryType(v string) *FunctionCodeLocation {
	s.RepositoryType = &v
	return s
}

// A Lambda function's configuration settings.
type FunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string `type:"string"`

	// The size of the function's deployment package in bytes.
	CodeSize *int64 `type:"long"`

	// The function's dead letter queue.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// The function's description.
	Description *string `type:"string"`

	// The function's environment variables.
	Environment *EnvironmentResponse `type:"structure"`

	// The function's Amazon Resource Name.
	FunctionArn *string `type:"string"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The function Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The KMS key used to encrypt the function's environment variables. Only returned
	// if you've configured a customer managed CMK.
	KMSKeyArn *string `type:"string"`

	// The date and time that the function was last updated, in ISO-8601 format
	// (https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModified *string `type:"string"`

	// A list of function layers (http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
	Layers []*Layer `type:"list"`

	// The ARN of the master function.
	MasterArn *string `type:"string"`

	// The memory allocated to the function
	MemorySize *int64 `min:"128" type:"integer"`

	// Represents the latest updated revision of the function or alias.
	RevisionId *string `type:"string"`

	// The function's execution role.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	Runtime *string `type:"string" enum:"Runtime"`

	// The amount of time that Lambda allows a function to run before terminating
	// it.
	Timeout *int64 `min:"1" type:"integer"`

	// The function's AWS X-Ray tracing configuration.
	TracingConfig *TracingConfigResponse `type:"structure"`

	// The version of the Lambda function.
	Version *string `min:"1" type:"string"`

	// The function's networking configuration.
	VpcConfig *VpcConfigResponse `type:"structure"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionConfiguration) GoString() string {
	return s.String()
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *FunctionConfiguration) SetCodeSha256(v string) *FunctionConfiguration {
	s.CodeSha256 = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *FunctionConfiguration) SetCodeSize(v int64) *FunctionConfiguration {
	s.CodeSize = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *FunctionConfiguration) SetDeadLetterConfig(v *DeadLetterConfig) *FunctionConfiguration {
	s.DeadLetterConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *FunctionConfiguration) SetDescription(v string) *FunctionConfiguration {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *FunctionConfiguration) SetEnvironment(v *EnvironmentResponse) *FunctionConfiguration {
	s.Environment = v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *FunctionConfiguration) SetFunctionArn(v string) *FunctionConfiguration {
	s.FunctionArn = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *FunctionConfiguration) SetFunctionName(v string) *FunctionConfiguration {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *FunctionConfiguration) SetHandler(v string) *FunctionConfiguration {
	s.Handler = &v
	return s
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *FunctionConfiguration) SetKMSKeyArn(v string) *FunctionConfiguration {
	s.KMSKeyArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *FunctionConfiguration) SetLastModified(v string) *FunctionConfiguration {
	s.LastModified = &v
	return s
}

// SetLayers sets the Layers field's value.
func (s *FunctionConfiguration) SetLayers(v []*Layer) *FunctionConfiguration {
	s.Layers = v
	return s
}

// SetMasterArn sets the MasterArn field's value.
func (s *FunctionConfiguration) SetMasterArn(v string) *FunctionConfiguration {
	s.MasterArn = &v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *FunctionConfiguration) SetMemorySize(v int64) *FunctionConfiguration {
	s.MemorySize = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *FunctionConfiguration) SetRevisionId(v string) *FunctionConfiguration {
	s.RevisionId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *FunctionConfiguration) SetRole(v string) *FunctionConfiguration {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *FunctionConfiguration) SetRuntime(v string) *FunctionConfiguration {
	s.Runtime = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *FunctionConfiguration) SetTimeout(v int64) *FunctionConfiguration {
	s.Timeout = &v
	return s
}

// SetTracingConfig sets the TracingConfig field's value.
func (s *FunctionConfiguration) SetTracingConfig(v *TracingConfigResponse) *FunctionConfiguration {
	s.TracingConfig = v
	return s
}

// SetVersion sets the Version field's value.
func (s *FunctionConfiguration) SetVersion(v string) *FunctionConfiguration {
	s.Version = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *FunctionConfiguration) SetVpcConfig(v *VpcConfigResponse) *FunctionConfiguration {
	s.VpcConfig = v
	return s
}

type GetAccountSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Limits related to concurrency and code storage.
	AccountLimit *AccountLimit `type:"structure"`

	// The number of functions and amount of storage in use.
	AccountUsage *AccountUsage `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountLimit sets the AccountLimit field's value.
func (s *GetAccountSettingsOutput) SetAccountLimit(v *AccountLimit) *GetAccountSettingsOutput {
	s.AccountLimit = v
	return s
}

// SetAccountUsage sets the AccountUsage field's value.
func (s *GetAccountSettingsOutput) SetAccountUsage(v *AccountUsage) *GetAccountSettingsOutput {
	s.AccountUsage = v
	return s
}

type GetAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Name of the alias for which you want to retrieve information.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetAliasInput) SetFunctionName(v string) *GetAliasInput {
	s.FunctionName = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAliasInput) SetName(v string) *GetAliasInput {
	s.Name = &v
	return s
}

type GetEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the event source mapping.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventSourceMappingInput"}
	if s.UUID == nil {
		invalidParams.Add(request.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUUID sets the UUID field's value.
func (s *GetEventSourceMappingInput) SetUUID(v string) *GetEventSourceMappingInput {
	s.UUID = &v
	return s
}

type GetFunctionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify a version or alias to get details about a published version of the
	// function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionConfigurationInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetFunctionConfigurationInput) SetFunctionName(v string) *GetFunctionConfigurationInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetFunctionConfigurationInput) SetQualifier(v string) *GetFunctionConfigurationInput {
	s.Qualifier = &v
	return s
}

type GetFunctionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify a version or alias to get details about a published version of the
	// function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetFunctionInput) SetFunctionName(v string) *GetFunctionInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetFunctionInput) SetQualifier(v string) *GetFunctionInput {
	s.Qualifier = &v
	return s
}

// This response contains the object for the Lambda function location (see FunctionCodeLocation.
type GetFunctionOutput struct {
	_ struct{} `type:"structure"`

	// The function's code.
	Code *FunctionCodeLocation `type:"structure"`

	// The concurrent execution limit set for this function. For more information,
	// see Managing Concurrency (http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
	Concurrency *PutFunctionConcurrencyOutput `type:"structure"`

	// The function's configuration.
	Configuration *FunctionConfiguration `type:"structure"`

	// Returns the list of tags associated with the function. For more information,
	// see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionOutput) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *GetFunctionOutput) SetCode(v *FunctionCodeLocation) *GetFunctionOutput {
	s.Code = v
	return s
}

// SetConcurrency sets the Concurrency field's value.
func (s *GetFunctionOutput) SetConcurrency(v *PutFunctionConcurrencyOutput) *GetFunctionOutput {
	s.Concurrency = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *GetFunctionOutput) SetConfiguration(v *FunctionConfiguration) *GetFunctionOutput {
	s.Configuration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetFunctionOutput) SetTags(v map[string]*string) *GetFunctionOutput {
	s.Tags = v
	return s
}

type GetLayerVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s GetLayerVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLayerVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLayerVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLayerVersionInput"}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerName sets the LayerName field's value.
func (s *GetLayerVersionInput) SetLayerName(v string) *GetLayerVersionInput {
	s.LayerName = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *GetLayerVersionInput) SetVersionNumber(v int64) *GetLayerVersionInput {
	s.VersionNumber = &v
	return s
}

type GetLayerVersionOutput struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes.
	CompatibleRuntimes []*string `type:"list"`

	// Details about the layer version.
	Content *LayerVersionContentOutput `type:"structure"`

	// The date that the layer version was created, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	CreatedDate *string `type:"string"`

	// The description of the version.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the function layer.
	LayerArn *string `min:"1" type:"string"`

	// The ARN of the layer version.
	LayerVersionArn *string `min:"1" type:"string"`

	// The layer's software license.
	LicenseInfo *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s GetLayerVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLayerVersionOutput) GoString() string {
	return s.String()
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *GetLayerVersionOutput) SetCompatibleRuntimes(v []*string) *GetLayerVersionOutput {
	s.CompatibleRuntimes = v
	return s
}

// SetContent sets the Content field's value.
func (s *GetLayerVersionOutput) SetContent(v *LayerVersionContentOutput) *GetLayerVersionOutput {
	s.Content = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetLayerVersionOutput) SetCreatedDate(v string) *GetLayerVersionOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetLayerVersionOutput) SetDescription(v string) *GetLayerVersionOutput {
	s.Description = &v
	return s
}

// SetLayerArn sets the LayerArn field's value.
func (s *GetLayerVersionOutput) SetLayerArn(v string) *GetLayerVersionOutput {
	s.LayerArn = &v
	return s
}

// SetLayerVersionArn sets the LayerVersionArn field's value.
func (s *GetLayerVersionOutput) SetLayerVersionArn(v string) *GetLayerVersionOutput {
	s.LayerVersionArn = &v
	return s
}

// SetLicenseInfo sets the LicenseInfo field's value.
func (s *GetLayerVersionOutput) SetLicenseInfo(v string) *GetLayerVersionOutput {
	s.LicenseInfo = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetLayerVersionOutput) SetVersion(v int64) *GetLayerVersionOutput {
	s.Version = &v
	return s
}

type GetLayerVersionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s GetLayerVersionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLayerVersionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLayerVersionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLayerVersionPolicyInput"}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerName sets the LayerName field's value.
func (s *GetLayerVersionPolicyInput) SetLayerName(v string) *GetLayerVersionPolicyInput {
	s.LayerName = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *GetLayerVersionPolicyInput) SetVersionNumber(v int64) *GetLayerVersionPolicyInput {
	s.VersionNumber = &v
	return s
}

type GetLayerVersionPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	Policy *string `type:"string"`

	// A unique identifier for the current revision of the policy.
	RevisionId *string `type:"string"`
}

// String returns the string representation
func (s GetLayerVersionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLayerVersionPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetLayerVersionPolicyOutput) SetPolicy(v string) *GetLayerVersionPolicyOutput {
	s.Policy = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *GetLayerVersionPolicyOutput) SetRevisionId(v string) *GetLayerVersionPolicyOutput {
	s.RevisionId = &v
	return s
}

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// You can specify this optional query parameter to specify a function version
	// or an alias name in which case this API will return all permissions associated
	// with the specific qualified ARN. If you don't provide this parameter, the
	// API will return permissions that apply to the unqualified function ARN.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetPolicyInput) SetFunctionName(v string) *GetPolicyInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetPolicyInput) SetQualifier(v string) *GetPolicyInput {
	s.Qualifier = &v
	return s
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The resource policy associated with the specified function. The response
	// returns the same as a string using a backslash ("\") as an escape character
	// in the JSON.
	Policy *string `type:"string"`

	// Represents the latest updated revision of the function or alias.
	RevisionId *string `type:"string"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetPolicyOutput) SetPolicy(v string) *GetPolicyOutput {
	s.Policy = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *GetPolicyOutput) SetRevisionId(v string) *GetPolicyOutput {
	s.RevisionId = &v
	return s
}

// Deprecated: InvokeAsyncInput has been deprecated
type InvokeAsyncInput struct {
	_ struct{} `deprecated:"true" type:"structure" payload:"InvokeArgs"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// JSON that you want to provide to your Lambda function as input.
	//
	// InvokeArgs is a required field
	InvokeArgs io.ReadSeeker `type:"blob" required:"true"`
}

// String returns the string representation
func (s InvokeAsyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeAsyncInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeAsyncInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.InvokeArgs == nil {
		invalidParams.Add(request.NewErrParamRequired("InvokeArgs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *InvokeAsyncInput) SetFunctionName(v string) *InvokeAsyncInput {
	s.FunctionName = &v
	return s
}

// SetInvokeArgs sets the InvokeArgs field's value.
func (s *InvokeAsyncInput) SetInvokeArgs(v io.ReadSeeker) *InvokeAsyncInput {
	s.InvokeArgs = v
	return s
}

// Upon success, it returns empty response. Otherwise, throws an exception.
//
// Deprecated: InvokeAsyncOutput has been deprecated
type InvokeAsyncOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// It will be 202 upon success.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s InvokeAsyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *InvokeAsyncOutput) SetStatus(v int64) *InvokeAsyncOutput {
	s.Status = &v
	return s
}

type InvokeInput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// Using the ClientContext you can pass client-specific information to the Lambda
	// function you are invoking. You can then process the client information in
	// your Lambda function as you choose through the context variable. For an example
	// of a ClientContext JSON, see PutEvents (http://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html)
	// in the Amazon Mobile Analytics API Reference and User Guide.
	//
	// The ClientContext JSON must be base64-encoded and has a maximum size of 3583
	// bytes.
	//
	// ClientContext information is returned only if you use the synchronous (RequestResponse)
	// invocation type.
	ClientContext *string `location:"header" locationName:"X-Amz-Client-Context" type:"string"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Choose from the following options.
	//
	//    * RequestResponse (default) - Invoke the function synchronously. Keep
	//    the connection open until the function returns a response or times out.
	//
	//    * Event - Invoke the function asynchronously. Send events that fail multiple
	//    times to the function's dead-letter queue (if configured).
	//
	//    * DryRun - Validate parameter values and verify that the user or role
	//    has permission to invoke the function.
	InvocationType *string `location:"header" locationName:"X-Amz-Invocation-Type" type:"string" enum:"InvocationType"`

	// You can set this optional parameter to Tail in the request only if you specify
	// the InvocationType parameter with value RequestResponse. In this case, AWS
	// Lambda returns the base64-encoded last 4 KB of log data produced by your
	// Lambda function in the x-amz-log-result header.
	LogType *string `location:"header" locationName:"X-Amz-Log-Type" type:"string" enum:"LogType"`

	// JSON that you want to provide to your Lambda function as input.
	Payload []byte `type:"blob"`

	// Specify a version or alias to invoke a published version of the function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s InvokeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientContext sets the ClientContext field's value.
func (s *InvokeInput) SetClientContext(v string) *InvokeInput {
	s.ClientContext = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *InvokeInput) SetFunctionName(v string) *InvokeInput {
	s.FunctionName = &v
	return s
}

// SetInvocationType sets the InvocationType field's value.
func (s *InvokeInput) SetInvocationType(v string) *InvokeInput {
	s.InvocationType = &v
	return s
}

// SetLogType sets the LogType field's value.
func (s *InvokeInput) SetLogType(v string) *InvokeInput {
	s.LogType = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *InvokeInput) SetPayload(v []byte) *InvokeInput {
	s.Payload = v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *InvokeInput) SetQualifier(v string) *InvokeInput {
	s.Qualifier = &v
	return s
}

// Upon success, returns an empty response. Otherwise, throws an exception.
type InvokeOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The function version that has been executed. This value is returned only
	// if the invocation type is RequestResponse. For more information, see Traffic
	// Shifting Using Aliases (http://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html).
	ExecutedVersion *string `location:"header" locationName:"X-Amz-Executed-Version" min:"1" type:"string"`

	// Indicates whether an error occurred while executing the Lambda function.
	// If an error occurred this field will have one of two values; Handled or Unhandled.
	// Handled errors are errors that are reported by the function while the Unhandled
	// errors are those detected and reported by AWS Lambda. Unhandled errors include
	// out of memory errors and function timeouts. For information about how to
	// report an Handled error, see Programming Model (http://docs.aws.amazon.com/lambda/latest/dg/programming-model.html).
	FunctionError *string `location:"header" locationName:"X-Amz-Function-Error" type:"string"`

	// It is the base64-encoded logs for the Lambda function invocation. This is
	// present only if the invocation type is RequestResponse and the logs were
	// requested.
	LogResult *string `location:"header" locationName:"X-Amz-Log-Result" type:"string"`

	// It is the JSON representation of the object returned by the Lambda function.
	// This is present only if the invocation type is RequestResponse.
	//
	// In the event of a function error this field contains a message describing
	// the error. For the Handled errors the Lambda function will report this message.
	// For Unhandled errors AWS Lambda reports the message.
	Payload []byte `type:"blob"`

	// The HTTP status code will be in the 200 range for successful request. For
	// the RequestResponse invocation type this status code will be 200. For the
	// Event invocation type this status code will be 202. For the DryRun invocation
	// type the status code will be 204.
	StatusCode *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s InvokeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeOutput) GoString() string {
	return s.String()
}

// SetExecutedVersion sets the ExecutedVersion field's value.
func (s *InvokeOutput) SetExecutedVersion(v string) *InvokeOutput {
	s.ExecutedVersion = &v
	return s
}

// SetFunctionError sets the FunctionError field's value.
func (s *InvokeOutput) SetFunctionError(v string) *InvokeOutput {
	s.FunctionError = &v
	return s
}

// SetLogResult sets the LogResult field's value.
func (s *InvokeOutput) SetLogResult(v string) *InvokeOutput {
	s.LogResult = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *InvokeOutput) SetPayload(v []byte) *InvokeOutput {
	s.Payload = v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *InvokeOutput) SetStatusCode(v int64) *InvokeOutput {
	s.StatusCode = &v
	return s
}

// A function layer.
type Layer struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the function layer.
	Arn *string `min:"1" type:"string"`

	// The size of the layer archive in bytes.
	CodeSize *int64 `type:"long"`
}

// String returns the string representation
func (s Layer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Layer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Layer) SetArn(v string) *Layer {
	s.Arn = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *Layer) SetCodeSize(v int64) *Layer {
	s.CodeSize = &v
	return s
}

// A ZIP archive that contains the contents of the function layer. You can specify
// either an Amazon S3 location, or upload a layer archive directly.
type LayerVersionContentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket of the layer archive.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 key of the layer archive.
	S3Key *string `min:"1" type:"string"`

	// For versioned objects, the version of the layer archive object to use.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The base64-encoded contents of the layer archive. AWS SDK and AWS CLI clients
	// handle the encoding for you.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s LayerVersionContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LayerVersionContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LayerVersionContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LayerVersionContentInput"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *LayerVersionContentInput) SetS3Bucket(v string) *LayerVersionContentInput {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *LayerVersionContentInput) SetS3Key(v string) *LayerVersionContentInput {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *LayerVersionContentInput) SetS3ObjectVersion(v string) *LayerVersionContentInput {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *LayerVersionContentInput) SetZipFile(v []byte) *LayerVersionContentInput {
	s.ZipFile = v
	return s
}

// Details about a layer version.
type LayerVersionContentOutput struct {
	_ struct{} `type:"structure"`

	// The SHA-256 hash of the layer archive.
	CodeSha256 *string `type:"string"`

	// The size of the layer archive in bytes.
	CodeSize *int64 `type:"long"`

	// A link to the layer archive in Amazon S3 that is valid for 10 minutes.
	Location *string `type:"string"`
}

// String returns the string representation
func (s LayerVersionContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LayerVersionContentOutput) GoString() string {
	return s.String()
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *LayerVersionContentOutput) SetCodeSha256(v string) *LayerVersionContentOutput {
	s.CodeSha256 = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *LayerVersionContentOutput) SetCodeSize(v int64) *LayerVersionContentOutput {
	s.CodeSize = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *LayerVersionContentOutput) SetLocation(v string) *LayerVersionContentOutput {
	s.Location = &v
	return s
}

// Details about a layer version.
type LayerVersionsListItem struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes.
	CompatibleRuntimes []*string `type:"list"`

	// The date that the version was created, in ISO 8601 format. For example, 2018-11-27T15:10:45.123+0000.
	CreatedDate *string `type:"string"`

	// The description of the version.
	Description *string `type:"string"`

	// The ARN of the layer version.
	LayerVersionArn *string `min:"1" type:"string"`

	// The layer's open-source license.
	LicenseInfo *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s LayerVersionsListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LayerVersionsListItem) GoString() string {
	return s.String()
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *LayerVersionsListItem) SetCompatibleRuntimes(v []*string) *LayerVersionsListItem {
	s.CompatibleRuntimes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *LayerVersionsListItem) SetCreatedDate(v string) *LayerVersionsListItem {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *LayerVersionsListItem) SetDescription(v string) *LayerVersionsListItem {
	s.Description = &v
	return s
}

// SetLayerVersionArn sets the LayerVersionArn field's value.
func (s *LayerVersionsListItem) SetLayerVersionArn(v string) *LayerVersionsListItem {
	s.LayerVersionArn = &v
	return s
}

// SetLicenseInfo sets the LicenseInfo field's value.
func (s *LayerVersionsListItem) SetLicenseInfo(v string) *LayerVersionsListItem {
	s.LicenseInfo = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *LayerVersionsListItem) SetVersion(v int64) *LayerVersionsListItem {
	s.Version = &v
	return s
}

// Details about a function layer.
type LayersListItem struct {
	_ struct{} `type:"structure"`

	// The newest version of the layer.
	LatestMatchingVersion *LayerVersionsListItem `type:"structure"`

	// The Amazon Resource Name (ARN) of the function layer.
	LayerArn *string `min:"1" type:"string"`

	// The name of the layer.
	LayerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LayersListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LayersListItem) GoString() string {
	return s.String()
}

// SetLatestMatchingVersion sets the LatestMatchingVersion field's value.
func (s *LayersListItem) SetLatestMatchingVersion(v *LayerVersionsListItem) *LayersListItem {
	s.LatestMatchingVersion = v
	return s
}

// SetLayerArn sets the LayerArn field's value.
func (s *LayersListItem) SetLayerArn(v string) *LayersListItem {
	s.LayerArn = &v
	return s
}

// SetLayerName sets the LayerName field's value.
func (s *LayersListItem) SetLayerName(v string) *LayersListItem {
	s.LayerName = &v
	return s
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// The name of the lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// If you specify this optional parameter, the API returns only the aliases
	// that are pointing to the specific Lambda function version, otherwise the
	// API returns all of the aliases created for the Lambda function.
	FunctionVersion *string `location:"querystring" locationName:"FunctionVersion" min:"1" type:"string"`

	// Optional string. An opaque pagination token returned from a previous ListAliases
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of aliases to return in response.
	// This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionVersion", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListAliasesInput) SetFunctionName(v string) *ListAliasesInput {
	s.FunctionName = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *ListAliasesInput) SetFunctionVersion(v string) *ListAliasesInput {
	s.FunctionVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAliasesInput) SetMarker(v string) *ListAliasesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListAliasesInput) SetMaxItems(v int64) *ListAliasesInput {
	s.MaxItems = &v
	return s
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of aliases.
	Aliases []*AliasConfiguration `type:"list"`

	// A string, present if there are more aliases.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *ListAliasesOutput) SetAliases(v []*AliasConfiguration) *ListAliasesOutput {
	s.Aliases = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListAliasesOutput) SetNextMarker(v string) *ListAliasesOutput {
	s.NextMarker = &v
	return s
}

type ListEventSourceMappingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the event source.
	//
	//    * Amazon Kinesis - The ARN of the data stream or a stream consumer.
	//
	//    * Amazon DynamoDB Streams - The ARN of the stream.
	//
	//    * Amazon Simple Queue Service - The ARN of the queue.
	EventSourceArn *string `location:"querystring" locationName:"EventSourceArn" type:"string"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Version or Alias ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it's limited to 64 characters in length.
	FunctionName *string `location:"querystring" locationName:"FunctionName" min:"1" type:"string"`

	// A pagination token returned by a previous call.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of event source mappings to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListEventSourceMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventSourceMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventSourceMappingsInput"}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *ListEventSourceMappingsInput) SetEventSourceArn(v string) *ListEventSourceMappingsInput {
	s.EventSourceArn = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListEventSourceMappingsInput) SetFunctionName(v string) *ListEventSourceMappingsInput {
	s.FunctionName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListEventSourceMappingsInput) SetMarker(v string) *ListEventSourceMappingsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListEventSourceMappingsInput) SetMaxItems(v int64) *ListEventSourceMappingsInput {
	s.MaxItems = &v
	return s
}

type ListEventSourceMappingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of event source mappings.
	EventSourceMappings []*EventSourceMappingConfiguration `type:"list"`

	// A pagination token that's returned when the response doesn't contain all
	// event source mappings.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListEventSourceMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsOutput) GoString() string {
	return s.String()
}

// SetEventSourceMappings sets the EventSourceMappings field's value.
func (s *ListEventSourceMappingsOutput) SetEventSourceMappings(v []*EventSourceMappingConfiguration) *ListEventSourceMappingsOutput {
	s.EventSourceMappings = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListEventSourceMappingsOutput) SetNextMarker(v string) *ListEventSourceMappingsOutput {
	s.NextMarker = &v
	return s
}

type ListFunctionsInput struct {
	_ struct{} `type:"structure"`

	// Set to ALL to list all published versions. If not specified, only the latest
	// unpublished version ARN is returned.
	FunctionVersion *string `location:"querystring" locationName:"FunctionVersion" type:"string" enum:"FunctionVersion"`

	// Optional string. An opaque pagination token returned from a previous ListFunctions
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Specify a region (e.g. us-east-2) to only list functions that were created
	// in that region, or ALL to include functions replicated from any region. If
	// specified, you also must specify the FunctionVersion.
	MasterRegion *string `location:"querystring" locationName:"MasterRegion" type:"string"`

	// Optional integer. Specifies the maximum number of AWS Lambda functions to
	// return in response. This parameter value must be greater than 0. The absolute
	// maximum of AWS Lambda functions that can be returned is 50.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListFunctionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFunctionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFunctionsInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *ListFunctionsInput) SetFunctionVersion(v string) *ListFunctionsInput {
	s.FunctionVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListFunctionsInput) SetMarker(v string) *ListFunctionsInput {
	s.Marker = &v
	return s
}

// SetMasterRegion sets the MasterRegion field's value.
func (s *ListFunctionsInput) SetMasterRegion(v string) *ListFunctionsInput {
	s.MasterRegion = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListFunctionsInput) SetMaxItems(v int64) *ListFunctionsInput {
	s.MaxItems = &v
	return s
}

// A list of Lambda functions.
type ListFunctionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Lambda functions.
	Functions []*FunctionConfiguration `type:"list"`

	// A string, present if there are more functions.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListFunctionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsOutput) GoString() string {
	return s.String()
}

// SetFunctions sets the Functions field's value.
func (s *ListFunctionsOutput) SetFunctions(v []*FunctionConfiguration) *ListFunctionsOutput {
	s.Functions = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListFunctionsOutput) SetNextMarker(v string) *ListFunctionsOutput {
	s.NextMarker = &v
	return s
}

type ListLayerVersionsInput struct {
	_ struct{} `type:"structure"`

	// A runtime identifier. For example, go1.x.
	CompatibleRuntime *string `location:"querystring" locationName:"CompatibleRuntime" type:"string" enum:"Runtime"`

	// The name of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// A pagination token returned by a previous call.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of versions to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListLayerVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLayerVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLayerVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLayerVersionsInput"}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleRuntime sets the CompatibleRuntime field's value.
func (s *ListLayerVersionsInput) SetCompatibleRuntime(v string) *ListLayerVersionsInput {
	s.CompatibleRuntime = &v
	return s
}

// SetLayerName sets the LayerName field's value.
func (s *ListLayerVersionsInput) SetLayerName(v string) *ListLayerVersionsInput {
	s.LayerName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListLayerVersionsInput) SetMarker(v string) *ListLayerVersionsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListLayerVersionsInput) SetMaxItems(v int64) *ListLayerVersionsInput {
	s.MaxItems = &v
	return s
}

type ListLayerVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of versions.
	LayerVersions []*LayerVersionsListItem `type:"list"`

	// A pagination token returned when the response doesn't contain all versions.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListLayerVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLayerVersionsOutput) GoString() string {
	return s.String()
}

// SetLayerVersions sets the LayerVersions field's value.
func (s *ListLayerVersionsOutput) SetLayerVersions(v []*LayerVersionsListItem) *ListLayerVersionsOutput {
	s.LayerVersions = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListLayerVersionsOutput) SetNextMarker(v string) *ListLayerVersionsOutput {
	s.NextMarker = &v
	return s
}

type ListLayersInput struct {
	_ struct{} `type:"structure"`

	// A runtime identifier. For example, go1.x.
	CompatibleRuntime *string `location:"querystring" locationName:"CompatibleRuntime" type:"string" enum:"Runtime"`

	// A pagination token returned by a previous call.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of layers to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListLayersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLayersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLayersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLayersInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleRuntime sets the CompatibleRuntime field's value.
func (s *ListLayersInput) SetCompatibleRuntime(v string) *ListLayersInput {
	s.CompatibleRuntime = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListLayersInput) SetMarker(v string) *ListLayersInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListLayersInput) SetMaxItems(v int64) *ListLayersInput {
	s.MaxItems = &v
	return s
}

type ListLayersOutput struct {
	_ struct{} `type:"structure"`

	// A list of function layers.
	Layers []*LayersListItem `type:"list"`

	// A pagination token returned when the response doesn't contain all layers.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListLayersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLayersOutput) GoString() string {
	return s.String()
}

// SetLayers sets the Layers field's value.
func (s *ListLayersOutput) SetLayers(v []*LayersListItem) *ListLayersOutput {
	s.Layers = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListLayersOutput) SetNextMarker(v string) *ListLayersOutput {
	s.NextMarker = &v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the function. For more information, see
	// Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"ARN" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *ListTagsInput) SetResource(v string) *ListTagsInput {
	s.Resource = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags assigned to the function. For more information, see Tagging
	// Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v map[string]*string) *ListTagsOutput {
	s.Tags = v
	return s
}

type ListVersionsByFunctionInput struct {
	_ struct{} `type:"structure"`

	// The name of the lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Optional string. An opaque pagination token returned from a previous ListVersionsByFunction
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of AWS Lambda function versions
	// to return in response. This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListVersionsByFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVersionsByFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVersionsByFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVersionsByFunctionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListVersionsByFunctionInput) SetFunctionName(v string) *ListVersionsByFunctionInput {
	s.FunctionName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListVersionsByFunctionInput) SetMarker(v string) *ListVersionsByFunctionInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListVersionsByFunctionInput) SetMaxItems(v int64) *ListVersionsByFunctionInput {
	s.MaxItems = &v
	return s
}

type ListVersionsByFunctionOutput struct {
	_ struct{} `type:"structure"`

	// A string, present if there are more function versions.
	NextMarker *string `type:"string"`

	// A list of Lambda function versions.
	Versions []*FunctionConfiguration `type:"list"`
}

// String returns the string representation
func (s ListVersionsByFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVersionsByFunctionOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListVersionsByFunctionOutput) SetNextMarker(v string) *ListVersionsByFunctionOutput {
	s.NextMarker = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListVersionsByFunctionOutput) SetVersions(v []*FunctionConfiguration) *ListVersionsByFunctionOutput {
	s.Versions = v
	return s
}

type PublishLayerVersionInput struct {
	_ struct{} `type:"structure"`

	// A list of compatible function runtimes (http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html).
	// Used for filtering with ListLayers and ListLayerVersions.
	CompatibleRuntimes []*string `type:"list"`

	// The function layer archive.
	//
	// Content is a required field
	Content *LayerVersionContentInput `type:"structure" required:"true"`

	// The description of the version.
	Description *string `type:"string"`

	// The name of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// The layer's software license. It can be any of the following:
	//
	//    * An SPDX license identifier (https://spdx.org/licenses/). For example,
	//    MIT.
	//
	//    * The URL of a license hosted on the internet. For example, https://opensource.org/licenses/MIT.
	//
	//    * The full text of the license.
	LicenseInfo *string `type:"string"`
}

// String returns the string representation
func (s PublishLayerVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishLayerVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishLayerVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishLayerVersionInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *PublishLayerVersionInput) SetCompatibleRuntimes(v []*string) *PublishLayerVersionInput {
	s.CompatibleRuntimes = v
	return s
}

// SetContent sets the Content field's value.
func (s *PublishLayerVersionInput) SetContent(v *LayerVersionContentInput) *PublishLayerVersionInput {
	s.Content = v
	return s
}

// SetDescription sets the Description field's value.
func (s *PublishLayerVersionInput) SetDescription(v string) *PublishLayerVersionInput {
	s.Description = &v
	return s
}

// SetLayerName sets the LayerName field's value.
func (s *PublishLayerVersionInput) SetLayerName(v string) *PublishLayerVersionInput {
	s.LayerName = &v
	return s
}

// SetLicenseInfo sets the LicenseInfo field's value.
func (s *PublishLayerVersionInput) SetLicenseInfo(v string) *PublishLayerVersionInput {
	s.LicenseInfo = &v
	return s
}

type PublishLayerVersionOutput struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes.
	CompatibleRuntimes []*string `type:"list"`

	// Details about the layer version.
	Content *LayerVersionContentOutput `type:"structure"`

	// The date that the layer version was created, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	CreatedDate *string `type:"string"`

	// The description of the version.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the function layer.
	LayerArn *string `min:"1" type:"string"`

	// The ARN of the layer version.
	LayerVersionArn *string `min:"1" type:"string"`

	// The layer's software license.
	LicenseInfo *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s PublishLayerVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishLayerVersionOutput) GoString() string {
	return s.String()
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *PublishLayerVersionOutput) SetCompatibleRuntimes(v []*string) *PublishLayerVersionOutput {
	s.CompatibleRuntimes = v
	return s
}

// SetContent sets the Content field's value.
func (s *PublishLayerVersionOutput) SetContent(v *LayerVersionContentOutput) *PublishLayerVersionOutput {
	s.Content = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PublishLayerVersionOutput) SetCreatedDate(v string) *PublishLayerVersionOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PublishLayerVersionOutput) SetDescription(v string) *PublishLayerVersionOutput {
	s.Description = &v
	return s
}

// SetLayerArn sets the LayerArn field's value.
func (s *PublishLayerVersionOutput) SetLayerArn(v string) *PublishLayerVersionOutput {
	s.LayerArn = &v
	return s
}

// SetLayerVersionArn sets the LayerVersionArn field's value.
func (s *PublishLayerVersionOutput) SetLayerVersionArn(v string) *PublishLayerVersionOutput {
	s.LayerVersionArn = &v
	return s
}

// SetLicenseInfo sets the LicenseInfo field's value.
func (s *PublishLayerVersionOutput) SetLicenseInfo(v string) *PublishLayerVersionOutput {
	s.LicenseInfo = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PublishLayerVersionOutput) SetVersion(v int64) *PublishLayerVersionOutput {
	s.Version = &v
	return s
}

type PublishVersionInput struct {
	_ struct{} `type:"structure"`

	// The SHA256 hash of the deployment package you want to publish. This provides
	// validation on the code you are publishing. If you provide this parameter,
	// the value must match the SHA256 of the $LATEST version for the publication
	// to succeed. You can use the DryRun parameter of UpdateFunctionCode to verify
	// the hash value that will be returned before publishing your new version.
	CodeSha256 *string `type:"string"`

	// The description for the version you are publishing. If not provided, AWS
	// Lambda copies the description from the $LATEST version.
	Description *string `type:"string"`

	// The name of the lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you retrieve the latest function version or alias RevisionID
	// using either GetFunction or GetAlias.
	RevisionId *string `type:"string"`
}

// String returns the string representation
func (s PublishVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishVersionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *PublishVersionInput) SetCodeSha256(v string) *PublishVersionInput {
	s.CodeSha256 = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PublishVersionInput) SetDescription(v string) *PublishVersionInput {
	s.Description = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *PublishVersionInput) SetFunctionName(v string) *PublishVersionInput {
	s.FunctionName = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *PublishVersionInput) SetRevisionId(v string) *PublishVersionInput {
	s.RevisionId = &v
	return s
}

type PutFunctionConcurrencyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The concurrent execution limit reserved for this function.
	//
	// ReservedConcurrentExecutions is a required field
	ReservedConcurrentExecutions *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PutFunctionConcurrencyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFunctionConcurrencyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFunctionConcurrencyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFunctionConcurrencyInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.ReservedConcurrentExecutions == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedConcurrentExecutions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *PutFunctionConcurrencyInput) SetFunctionName(v string) *PutFunctionConcurrencyInput {
	s.FunctionName = &v
	return s
}

// SetReservedConcurrentExecutions sets the ReservedConcurrentExecutions field's value.
func (s *PutFunctionConcurrencyInput) SetReservedConcurrentExecutions(v int64) *PutFunctionConcurrencyInput {
	s.ReservedConcurrentExecutions = &v
	return s
}

type PutFunctionConcurrencyOutput struct {
	_ struct{} `type:"structure"`

	// The number of concurrent executions reserved for this function. For more
	// information, see Managing Concurrency (http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
	ReservedConcurrentExecutions *int64 `type:"integer"`
}

// String returns the string representation
func (s PutFunctionConcurrencyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFunctionConcurrencyOutput) GoString() string {
	return s.String()
}

// SetReservedConcurrentExecutions sets the ReservedConcurrentExecutions field's value.
func (s *PutFunctionConcurrencyOutput) SetReservedConcurrentExecutions(v int64) *PutFunctionConcurrencyOutput {
	s.ReservedConcurrentExecutions = &v
	return s
}

type RemoveLayerVersionPermissionInput struct {
	_ struct{} `type:"structure"`

	// The name of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// Only update the policy if the revision ID matches the ID specified. Use this
	// option to avoid modifying a policy that has changed since you last read it.
	RevisionId *string `location:"querystring" locationName:"RevisionId" type:"string"`

	// The identifier that was specified when the statement was added.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"StatementId" min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s RemoveLayerVersionPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveLayerVersionPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveLayerVersionPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveLayerVersionPermissionInput"}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerName sets the LayerName field's value.
func (s *RemoveLayerVersionPermissionInput) SetLayerName(v string) *RemoveLayerVersionPermissionInput {
	s.LayerName = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *RemoveLayerVersionPermissionInput) SetRevisionId(v string) *RemoveLayerVersionPermissionInput {
	s.RevisionId = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *RemoveLayerVersionPermissionInput) SetStatementId(v string) *RemoveLayerVersionPermissionInput {
	s.StatementId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *RemoveLayerVersionPermissionInput) SetVersionNumber(v int64) *RemoveLayerVersionPermissionInput {
	s.VersionNumber = &v
	return s
}

type RemoveLayerVersionPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveLayerVersionPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveLayerVersionPermissionOutput) GoString() string {
	return s.String()
}

type RemovePermissionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify a version or alias to remove permissions from a published version
	// of the function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you to retrieve the latest function version or alias RevisionID
	// using either GetFunction or GetAlias.
	RevisionId *string `location:"querystring" locationName:"RevisionId" type:"string"`

	// Statement ID of the permission to remove.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"StatementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemovePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemovePermissionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *RemovePermissionInput) SetFunctionName(v string) *RemovePermissionInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *RemovePermissionInput) SetQualifier(v string) *RemovePermissionInput {
	s.Qualifier = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *RemovePermissionInput) SetRevisionId(v string) *RemovePermissionInput {
	s.RevisionId = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *RemovePermissionInput) SetStatementId(v string) *RemovePermissionInput {
	s.StatementId = &v
	return s
}

type RemovePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the Lambda function. For more information,
	// see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"ARN" type:"string" required:"true"`

	// The list of tags (key-value pairs) you are assigning to the Lambda function.
	// For more information, see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *TagResourceInput) SetResource(v string) *TagResourceInput {
	s.Resource = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The function's AWS X-Ray tracing configuration.
type TracingConfig struct {
	_ struct{} `type:"structure"`

	// The tracing mode.
	Mode *string `type:"string" enum:"TracingMode"`
}

// String returns the string representation
func (s TracingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TracingConfig) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *TracingConfig) SetMode(v string) *TracingConfig {
	s.Mode = &v
	return s
}

// The function's AWS X-Ray tracing configuration.
type TracingConfigResponse struct {
	_ struct{} `type:"structure"`

	// The tracing mode.
	Mode *string `type:"string" enum:"TracingMode"`
}

// String returns the string representation
func (s TracingConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TracingConfigResponse) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *TracingConfigResponse) SetMode(v string) *TracingConfigResponse {
	s.Mode = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the function. For more information, see
	// Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"ARN" type:"string" required:"true"`

	// The list of tag keys to be deleted from the function. For more information,
	// see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *UntagResourceInput) SetResource(v string) *UntagResourceInput {
	s.Resource = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// You can change the description of the alias using this parameter.
	Description *string `type:"string"`

	// The name of the lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this parameter you can change the Lambda function version to which
	// the alias points.
	FunctionVersion *string `min:"1" type:"string"`

	// The alias name.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you retrieve the latest function version or alias RevisionID
	// using either GetFunction or GetAlias.
	RevisionId *string `type:"string"`

	// Specifies an additional version your alias can point to, allowing you to
	// dictate what percentage of traffic will invoke each version. For more information,
	// see Traffic Shifting Using Aliases (http://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html).
	RoutingConfig *AliasRoutingConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateAliasInput) SetDescription(v string) *UpdateAliasInput {
	s.Description = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateAliasInput) SetFunctionName(v string) *UpdateAliasInput {
	s.FunctionName = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *UpdateAliasInput) SetFunctionVersion(v string) *UpdateAliasInput {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAliasInput) SetName(v string) *UpdateAliasInput {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateAliasInput) SetRevisionId(v string) *UpdateAliasInput {
	s.RevisionId = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *UpdateAliasInput) SetRoutingConfig(v *AliasRoutingConfiguration) *UpdateAliasInput {
	s.RoutingConfig = v
	return s
}

type UpdateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	//
	//    * Amazon Kinesis - Default 100. Max 10,000.
	//
	//    * Amazon DynamoDB Streams - Default 100. Max 1,000.
	//
	//    * Amazon Simple Queue Service - Default 10. Max 10.
	BatchSize *int64 `min:"1" type:"integer"`

	// Disables the event source mapping to pause polling and invocation.
	Enabled *bool `type:"boolean"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Version or Alias ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it's limited to 64 characters in length.
	FunctionName *string `min:"1" type:"string"`

	// The identifier of the event source mapping.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEventSourceMappingInput"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.UUID == nil {
		invalidParams.Add(request.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *UpdateEventSourceMappingInput) SetBatchSize(v int64) *UpdateEventSourceMappingInput {
	s.BatchSize = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateEventSourceMappingInput) SetEnabled(v bool) *UpdateEventSourceMappingInput {
	s.Enabled = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateEventSourceMappingInput) SetFunctionName(v string) *UpdateEventSourceMappingInput {
	s.FunctionName = &v
	return s
}

// SetUUID sets the UUID field's value.
func (s *UpdateEventSourceMappingInput) SetUUID(v string) *UpdateEventSourceMappingInput {
	s.UUID = &v
	return s
}

type UpdateFunctionCodeInput struct {
	_ struct{} `type:"structure"`

	// This boolean parameter can be used to test your request to AWS Lambda to
	// update the Lambda function and publish a version as an atomic operation.
	// It will do all necessary computation and validation of your code but will
	// not upload it or a publish a version. Each time this operation is invoked,
	// the CodeSha256 hash value of the provided code will also be computed and
	// returned in the response.
	DryRun *bool `type:"boolean"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// This boolean parameter can be used to request AWS Lambda to update the Lambda
	// function and publish a version as an atomic operation.
	Publish *bool `type:"boolean"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you to retrieve the latest function version or alias RevisionID
	// using either using using either GetFunction or GetAlias.
	RevisionId *string `type:"string"`

	// Amazon S3 bucket name where the .zip file containing your deployment package
	// is stored. This bucket must reside in the same AWS Region where you are creating
	// the Lambda function.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 object (the deployment package) key name you want to upload.
	S3Key *string `min:"1" type:"string"`

	// The Amazon S3 object (the deployment package) version you want to upload.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The contents of your zip file containing your deployment package. If you
	// are using the web API directly, the contents of the zip file must be base64-encoded.
	// If you are using the AWS SDKs or the AWS CLI, the SDKs or CLI will do the
	// encoding for you. For more information about creating a .zip file, see Execution
	// Permissions (http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html).
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s UpdateFunctionCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFunctionCodeInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *UpdateFunctionCodeInput) SetDryRun(v bool) *UpdateFunctionCodeInput {
	s.DryRun = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateFunctionCodeInput) SetFunctionName(v string) *UpdateFunctionCodeInput {
	s.FunctionName = &v
	return s
}

// SetPublish sets the Publish field's value.
func (s *UpdateFunctionCodeInput) SetPublish(v bool) *UpdateFunctionCodeInput {
	s.Publish = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateFunctionCodeInput) SetRevisionId(v string) *UpdateFunctionCodeInput {
	s.RevisionId = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *UpdateFunctionCodeInput) SetS3Bucket(v string) *UpdateFunctionCodeInput {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *UpdateFunctionCodeInput) SetS3Key(v string) *UpdateFunctionCodeInput {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *UpdateFunctionCodeInput) SetS3ObjectVersion(v string) *UpdateFunctionCodeInput {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *UpdateFunctionCodeInput) SetZipFile(v []byte) *UpdateFunctionCodeInput {
	s.ZipFile = v
	return s
}

type UpdateFunctionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A dead letter queue configuration that specifies the queue or topic where
	// Lambda sends asynchronous events when they fail processing. For more information,
	// see Dead Letter Queues (http://docs.aws.amazon.com/lambda/latest/dg/dlq.html).
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// A short user-defined function description. AWS Lambda does not use this value.
	// Assign a meaningful description as you see fit.
	Description *string `type:"string"`

	// The parent object that contains your environment's configuration settings.
	Environment *Environment `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The function that Lambda calls to begin executing your function. For Node.js,
	// it is the module-name.export value in your function.
	Handler *string `type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt your function's
	// environment variables. If you elect to use the AWS Lambda default service
	// key, pass in an empty string ("") for this parameter.
	KMSKeyArn *string `type:"string"`

	// A list of function layers (http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
	// to add to the function's execution environment.
	Layers []*string `type:"list"`

	// The amount of memory, in MB, your Lambda function is given. AWS Lambda uses
	// this memory size to infer the amount of CPU allocated to your function. Your
	// function use-case determines your CPU and memory requirements. For example,
	// a database operation might need less memory compared to an image processing
	// function. The default value is 128 MB. The value must be a multiple of 64
	// MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you to retrieve the latest function version or alias RevisionID
	// using either GetFunction or GetAlias.
	RevisionId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda will assume when
	// it executes your function.
	Role *string `type:"string"`

	// The runtime version for the function.
	Runtime *string `type:"string" enum:"Runtime"`

	// The amount of time that Lambda allows a function to run before terminating
	// it. The default is 3 seconds. The maximum allowed value is 900 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// Set Mode to Active to sample and trace a subset of incoming requests with
	// AWS X-Ray.
	TracingConfig *TracingConfig `type:"structure"`

	// Specify security groups and subnets in a VPC to which your Lambda function
	// needs access.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFunctionConfigurationInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MemorySize != nil && *s.MemorySize < 128 {
		invalidParams.Add(request.NewErrParamMinValue("MemorySize", 128))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *UpdateFunctionConfigurationInput) SetDeadLetterConfig(v *DeadLetterConfig) *UpdateFunctionConfigurationInput {
	s.DeadLetterConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFunctionConfigurationInput) SetDescription(v string) *UpdateFunctionConfigurationInput {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateFunctionConfigurationInput) SetEnvironment(v *Environment) *UpdateFunctionConfigurationInput {
	s.Environment = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateFunctionConfigurationInput) SetFunctionName(v string) *UpdateFunctionConfigurationInput {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *UpdateFunctionConfigurationInput) SetHandler(v string) *UpdateFunctionConfigurationInput {
	s.Handler = &v
	return s
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *UpdateFunctionConfigurationInput) SetKMSKeyArn(v string) *UpdateFunctionConfigurationInput {
	s.KMSKeyArn = &v
	return s
}

// SetLayers sets the Layers field's value.
func (s *UpdateFunctionConfigurationInput) SetLayers(v []*string) *UpdateFunctionConfigurationInput {
	s.Layers = v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *UpdateFunctionConfigurationInput) SetMemorySize(v int64) *UpdateFunctionConfigurationInput {
	s.MemorySize = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateFunctionConfigurationInput) SetRevisionId(v string) *UpdateFunctionConfigurationInput {
	s.RevisionId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateFunctionConfigurationInput) SetRole(v string) *UpdateFunctionConfigurationInput {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *UpdateFunctionConfigurationInput) SetRuntime(v string) *UpdateFunctionConfigurationInput {
	s.Runtime = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *UpdateFunctionConfigurationInput) SetTimeout(v int64) *UpdateFunctionConfigurationInput {
	s.Timeout = &v
	return s
}

// SetTracingConfig sets the TracingConfig field's value.
func (s *UpdateFunctionConfigurationInput) SetTracingConfig(v *TracingConfig) *UpdateFunctionConfigurationInput {
	s.TracingConfig = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *UpdateFunctionConfigurationInput) SetVpcConfig(v *VpcConfig) *UpdateFunctionConfigurationInput {
	s.VpcConfig = v
	return s
}

// The VPC security groups and subnets attached to a Lambda function.
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of VPC security groups IDs.
	SecurityGroupIds []*string `type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfig) SetSecurityGroupIds(v []*string) *VpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfig) SetSubnetIds(v []*string) *VpcConfig {
	s.SubnetIds = v
	return s
}

// The VPC security groups and subnets attached to a Lambda function.
type VpcConfigResponse struct {
	_ struct{} `type:"structure"`

	// A list of VPC security groups IDs.
	SecurityGroupIds []*string `type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []*string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s VpcConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigResponse) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigResponse) SetSecurityGroupIds(v []*string) *VpcConfigResponse {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigResponse) SetSubnetIds(v []*string) *VpcConfigResponse {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigResponse) SetVpcId(v string) *VpcConfigResponse {
	s.VpcId = &v
	return s
}

const (
	// EventSourcePositionTrimHorizon is a EventSourcePosition enum value
	EventSourcePositionTrimHorizon = "TRIM_HORIZON"

	// EventSourcePositionLatest is a EventSourcePosition enum value
	EventSourcePositionLatest = "LATEST"

	// EventSourcePositionAtTimestamp is a EventSourcePosition enum value
	EventSourcePositionAtTimestamp = "AT_TIMESTAMP"
)

const (
	// FunctionVersionAll is a FunctionVersion enum value
	FunctionVersionAll = "ALL"
)

const (
	// InvocationTypeEvent is a InvocationType enum value
	InvocationTypeEvent = "Event"

	// InvocationTypeRequestResponse is a InvocationType enum value
	InvocationTypeRequestResponse = "RequestResponse"

	// InvocationTypeDryRun is a InvocationType enum value
	InvocationTypeDryRun = "DryRun"
)

const (
	// LogTypeNone is a LogType enum value
	LogTypeNone = "None"

	// LogTypeTail is a LogType enum value
	LogTypeTail = "Tail"
)

const (
	// RuntimeNodejs is a Runtime enum value
	RuntimeNodejs = "nodejs"

	// RuntimeNodejs43 is a Runtime enum value
	RuntimeNodejs43 = "nodejs4.3"

	// RuntimeNodejs610 is a Runtime enum value
	RuntimeNodejs610 = "nodejs6.10"

	// RuntimeNodejs810 is a Runtime enum value
	RuntimeNodejs810 = "nodejs8.10"

	// RuntimeJava8 is a Runtime enum value
	RuntimeJava8 = "java8"

	// RuntimePython27 is a Runtime enum value
	RuntimePython27 = "python2.7"

	// RuntimePython36 is a Runtime enum value
	RuntimePython36 = "python3.6"

	// RuntimePython37 is a Runtime enum value
	RuntimePython37 = "python3.7"

	// RuntimeDotnetcore10 is a Runtime enum value
	RuntimeDotnetcore10 = "dotnetcore1.0"

	// RuntimeDotnetcore20 is a Runtime enum value
	RuntimeDotnetcore20 = "dotnetcore2.0"

	// RuntimeDotnetcore21 is a Runtime enum value
	RuntimeDotnetcore21 = "dotnetcore2.1"

	// RuntimeNodejs43Edge is a Runtime enum value
	RuntimeNodejs43Edge = "nodejs4.3-edge"

	// RuntimeGo1X is a Runtime enum value
	RuntimeGo1X = "go1.x"

	// RuntimeRuby25 is a Runtime enum value
	RuntimeRuby25 = "ruby2.5"

	// RuntimeProvided is a Runtime enum value
	RuntimeProvided = "provided"
)

const (
	// ThrottleReasonConcurrentInvocationLimitExceeded is a ThrottleReason enum value
	ThrottleReasonConcurrentInvocationLimitExceeded = "ConcurrentInvocationLimitExceeded"

	// ThrottleReasonFunctionInvocationRateLimitExceeded is a ThrottleReason enum value
	ThrottleReasonFunctionInvocationRateLimitExceeded = "FunctionInvocationRateLimitExceeded"

	// ThrottleReasonReservedFunctionConcurrentInvocationLimitExceeded is a ThrottleReason enum value
	ThrottleReasonReservedFunctionConcurrentInvocationLimitExceeded = "ReservedFunctionConcurrentInvocationLimitExceeded"

	// ThrottleReasonReservedFunctionInvocationRateLimitExceeded is a ThrottleReason enum value
	ThrottleReasonReservedFunctionInvocationRateLimitExceeded = "ReservedFunctionInvocationRateLimitExceeded"

	// ThrottleReasonCallerRateLimitExceeded is a ThrottleReason enum value
	ThrottleReasonCallerRateLimitExceeded = "CallerRateLimitExceeded"
)

const (
	// TracingModeActive is a TracingMode enum value
	TracingModeActive = "Active"

	// TracingModePassThrough is a TracingMode enum value
	TracingModePassThrough = "PassThrough"
)
