Graphite Ingest Analysis Toolkit
===

This python script comes fully loaded to allow the user to take `tcpdump` packet captures from a graphite cluster and weave them together to get a sense of
live data ingestion happening within the cluster.

Collecting Ingest Data
---

Run a packet capture on each node in the cluster like so: `sudo tcpdump -i ens3 -A tcp port 2009 -G 120 -W 1 -w pcap`

This will scrape incoming graphite metrics (port 2009 on graphite-whisper hosts), for 120 seconds and writes to a file called `pcap`.
It is important to `tcpdump` for at least 2 minutes so that all unique active metrics have a chance to submit a datapoint and be counted.

Collect all of these dumps (at 2 minutes, each one is about 300MB), and put them into some common directory

Using the Tool
---

The script has many options to all you to slice and dice the data in any way you choose. Here are some example use cases

```
# Get the 100 servers that ingest the most system metrics, save as a CSV
python analyze.py --ingestdir /path/to/pcaps --top 100 --min-depth 2 --max-depth 2 --shift-root servers --outfile servers.csv --format csv

# Save the entire tree of metric buckets as a JSON object
python analyze.py --ingestdir /path/to/pcaps --outfile tree.json --format json

# Pretty print the top 50 buckets in the stats dir, with no depth restrictions
python analyze.py --ingestdir /path/to/pcaps --top 50 --print pretty --shift-root stats

# Find the top 5 top-level buckets in stats.counters, print as a sorted list
python analyze.py --ingestdir /path/to/pcaps --top 5 --print list --shift-root stats.counters
```

To Do
---

* Allow globbing/aggregating of fields; i.e. answer questions like "what bucket names inside `servers.*` have the highest aggregated cardinality? e.g. `tcp`, `iostat`, etc."
