package main

import (
	c "code.justin.tv/availability/hms-echo/pkg/config"
	"code.justin.tv/availability/hms-echo/pkg/echo"

	"github.com/heroku/rollrus"
	"github.com/sirupsen/logrus"
)

func main() {
	loglevel, err := logrus.ParseLevel(c.Config.LogLevel)
	if err != nil {
		logrus.Fatal("Couldn't parse log level %s: %s", c.Config.LogLevel, err)
	}
	logrus.SetLevel(loglevel)

	rollrus.SetupLogging(c.Config.RollbarAccessToken, c.Config.RollbarEnvironment)
	// rollrus disables timestamps. we reset the formatter afterwards to get them back
	logrus.SetFormatter(&logrus.TextFormatter{})
	logrus.Printf("Running with config: %+v", c.Config)
	statsdClient := c.NewStatter(c.Config)
	defer statsdClient.Close()
	echo.Run()
}
