package config

import "os"

type Configuration struct {
	Environment        string
	CatalogAPI         string
	CatalogGraphQLAPI  string
	QueueURL           string
	SQSEndpoint        string
	DynamoDBEndpoint   string
	DynamoDBTable      string
	Region             string
	EskAPI             string
	RollbarAccessToken string
	RollbarEnvironment string
	LogLevel           string
	AcceptAfterRetries int
}

var Config Configuration

func init() {
	setupConfig()
}

func setupConfig() {
	env := os.Getenv("ENVIRONMENT")
	switch env {
	case "production":
		Config = Configuration{
			Environment:        "production",
			DynamoDBEndpoint:   "http://dynamodb.us-west-2.amazonaws.com",
			DynamoDBTable:      "GoracleQueryHistory",
			QueueURL:           "https://sqs.us-west-2.amazonaws.com/007917851548/echo-worker",
			CatalogAPI:         "https://status.internal.justin.tv/api/v1",
			CatalogGraphQLAPI:  "https://status.internal.justin.tv/api/v2/query",
			Region:             "us-west-2",
			SQSEndpoint:        "",
			EskAPI:             "https://hms-esk.internal.justin.tv/v1",
			RollbarAccessToken: "c24bb02fa12b4be6b31744eb12681c12",
			RollbarEnvironment: "production",
			LogLevel:           "warn",
			AcceptAfterRetries: 1,
		}
	case "development":
		Config = Configuration{
			Environment:        "development",
			DynamoDBEndpoint:   "http://dynamodb.us-west-2.amazonaws.com",
			DynamoDBTable:      "GoracleQueryHistory",
			QueueURL:           "https://sqs.us-west-2.amazonaws.com/386434559102/echo-worker",
			CatalogAPI:         "https://status-development.internal.justin.tv/api/v1",
			CatalogGraphQLAPI:  "https://status-development.internal.justin.tv/api/v2/query",
			Region:             "us-west-2",
			SQSEndpoint:        "",
			EskAPI:             "https://hms-esk-development.internal.justin.tv/v1",
			RollbarAccessToken: "c24bb02fa12b4be6b31744eb12681c12",
			RollbarEnvironment: "development",
			LogLevel:           "info",
			AcceptAfterRetries: 1,
		}
	default:
		// assuming local dev env
		Config = Configuration{
			Environment:        "local",
			DynamoDBEndpoint:   "http://localhost:8001/",
			DynamoDBTable:      "GoracleQueryHistory",
			QueueURL:           "http://localhost:4100/test1",
			CatalogAPI:         "https://status-development.internal.justin.tv/api/v1",
			CatalogGraphQLAPI:  "https://status-development.internal.justin.tv/api/v2/query",
			Region:             "us-west-2",
			SQSEndpoint:        "http://localhost:4100",
			EskAPI:             "https://hms-esk-development.internal.justin.tv/v1",
			RollbarAccessToken: "",
			RollbarEnvironment: "local",
			LogLevel:           "info",
			AcceptAfterRetries: 1,
		}
	}
}
