package config

import (
	"fmt"
	"time"

	"github.com/cactus/go-statsd-client/statsd"
	"github.com/sirupsen/logrus"
)

var statsdClient statsd.Statter

func NewStatter(Config Configuration) statsd.Statter {
	prefix := fmt.Sprintf("hms.echo.%s", Config.Environment)
	// first create a client
	// The basic client sends one stat per packet (for compatibility).
	client, err := statsd.NewBufferedClient("127.0.0.1:8125", prefix, 1*time.Second, 1432)

	// handle any errors
	if err != nil {
		logrus.Error(err)
		statsdClient, _ = statsd.NewNoopClient()
		return statsdClient
	}
	// make sure to clean up
	statsdClient = client
	err = client.Inc("statsd.initialized", 42, 1.0)
	if err != nil {
		logrus.Error(err)
		return nil
	}
	return client
}

func GetStatter() statsd.Statter {
	return statsdClient
}
