package echo

import (
	"encoding/json"
	"strconv"
	"time"

	c "code.justin.tv/availability/hms-echo/pkg/config"
	"code.justin.tv/availability/hms-echo/pkg/graphite"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/sirupsen/logrus"
)

const (
	dynamoTimeFormat = "2006-01-02"
)

func dynamoPut(queryid uint, t time.Time, graphiteData *graphite.GraphiteData) error {
	conf := &aws.Config{Region: aws.String("us-west-2"), Endpoint: aws.String(c.Config.DynamoDBEndpoint)}
	dynamo := dynamodb.New(session.New(), conf.WithMaxRetries(10))
	var err error
	var dataBlob []byte

	if dataBlob, err = json.Marshal(graphiteData); err != nil {
		logrus.Errorf(err.Error())
		return err
	}

	params := &dynamodb.PutItemInput{
		TableName: aws.String(c.Config.DynamoDBTable),
		Item: map[string]*dynamodb.AttributeValue{
			"QueryID": {
				S: aws.String(strconv.Itoa(int(queryid))),
			},
			"Date": {
				S: aws.String(t.UTC().Format(dynamoTimeFormat)),
			},
			"Data": {
				S: aws.String(string(dataBlob)),
			},
		},
	}

	_, err = dynamo.PutItem(params)
	if err != nil {
		logrus.Debugf(err.Error())
		return err
	}

	return nil
}
