// +build manual

package echo

import (
	"encoding/json"
	"fmt"
	"log"
	"testing"

	"code.justin.tv/availability/hms-echo/pkg/graphqlcatalog"
)

func TestFindAllQueries(t *testing.T) {
	queries, err := FindAllQueries()
	if err != nil {
		log.Fatal(err)
	}

	//      spew.Dump(qs)

	for _, q := range queries {
		id, err := graphqlcatalog.IDStringToUint(*q.ID)
		if err != nil {
			log.Fatal(err)
		}
		r := &echoRequest{
			QueryID:       &id,
			Query:         *q.Query,
			AggregateType: *q.AggregateType,
		}
		msg, err := json.Marshal(r)
		if err != nil {
			log.Fatal(err)
		}
		fmt.Println(string(msg))
	}
}
