package graphite

import (
	"reflect"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestSumAggregate(t *testing.T) {
	assert := assert.New(t)
	nilData := []*float64{nil, nil}
	one := 1.0
	three := 3.0
	partNilData := []*float64{nil, &one, nil, &three}

	// Test sums
	sumNil := SumAggregate(nilData)
	sumPartNil := SumAggregate(partNilData)
	assert.Nil(sumNil)
	assert.Equal(*sumPartNil, 4.0, "should be sum of 1 and 3")
}

func TestAverageAggregate(t *testing.T) {
	assert := assert.New(t)
	nilData := []*float64{nil, nil}
	one := 1.0
	three := 3.0
	partNilData := []*float64{nil, &one, nil, &three}

	// Test averages
	avgNil := AverageAggregate(nilData)
	avgPartNil := AverageAggregate(partNilData)
	assert.Nil(avgNil)
	assert.Equal(*avgPartNil, 2.0, "should be average of 1 and 3")
}

func TestMaxAggregate(t *testing.T) {
	assert := assert.New(t)
	nilData := []*float64{nil, nil}
	one := 1.0
	three := 3.0
	partNilData := []*float64{nil, &one, nil, &three}

	// Test sums
	sumNil := MaxAggregate(nilData)
	sumPartNil := MaxAggregate(partNilData)
	assert.Nil(sumNil)
	assert.Equal(*sumPartNil, 3.0, "should be max of 1 and 3")
}

func TestGetAggregateFunction(t *testing.T) {
	assert := assert.New(t)
	// compare the
	assert.Equal(reflect.ValueOf(GetAggregateFunction(Sum)).Pointer(), reflect.ValueOf(SumAggregate).Pointer(), "should be sum function")
	assert.Equal(reflect.ValueOf(GetAggregateFunction(Max)).Pointer(), reflect.ValueOf(MaxAggregate).Pointer(), "should be max function")
	assert.Equal(reflect.ValueOf(GetAggregateFunction(Average)).Pointer(), reflect.ValueOf(AverageAggregate).Pointer(), "should be average function")
}
