package graphqlcatalog

import (
	"testing"

	"github.com/sirupsen/logrus"
	"github.com/stretchr/testify/assert"
)

func TestQuery(t *testing.T) {
	qStr := `{
    metrics(attribute_name:"latency_report") {
      id
      name
      component {
        id
        name
        service {
          id
          name
          team {
            id
            name
            org {
              id
              name
            }
          }
        }
      }
      queries {
        id
        query_type
      }
      attributes {
        name
        value
      }
    }
  }`

	q := GraphqlQuery{
		Query: &qStr,
	}

	r, err := GetGraphQL(q)
	assert.NoError(t, err)
	logrus.Println(*(*(*r.Data.Metrics)[0].Queries)[0].ID)
}
