package jsonrequest

import (
	"bytes"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/sirupsen/logrus"
)

func Do(method, url string, v, r interface{}) error {
	b := new(bytes.Buffer)
	if v != nil {
		err := json.NewEncoder(b).Encode(v)
		if err != nil {
			return err
		}
	}
	client := &http.Client{}
	req, err := http.NewRequest(method, url, b)
	if err != nil {
		return err
	}
	req.Header.Set("Content-Type", "application/json; charset=utf-8")
	resp, err := client.Do(req)
	if err != nil {
		return err
	}
	if resp.StatusCode != 200 && resp.StatusCode != 201 {
		return fmt.Errorf("Status not OK: %d", resp.StatusCode)
	}

	body, err := ioutil.ReadAll(resp.Body)
	defer resp.Body.Close()
	if err != nil {
		return err
	}

	if len(body) == 0 {
		// Empty data, just don't parse
		return nil
	}

	err = json.Unmarshal(body, r)
	if err != nil {
		logrus.Info("Failing to unmarshal response")
		return err
	}
	return nil
}

func Put(url string, v, r interface{}) error {
	return Do("PUT", url, v, r)
}

func Post(url string, v, r interface{}) error {
	return Do("POST", url, v, r)
}

func Get(url string, r interface{}) error {
	return Do("GET", url, nil, r)
}
