package reportbuilder

import (
	"time"

	c "code.justin.tv/availability/hms-echo/pkg/config"

	"code.justin.tv/availability/hms-echo/pkg/jsonrequest"
	"code.justin.tv/availability/hms-esk/pkg/reportdata"
	"github.com/sirupsen/logrus"
)

func AvailabilityReport(week time.Time, acceptMissing bool) error {
	buAvailabilityReports, err := BuildAvailabilityReport(week, acceptMissing)
	if err != nil {
		return err
	}

	ri := reportdata.ReportItem{
		ReportID:   "availability",
		Date:       week,
		ReportName: "availability",
		Data:       buAvailabilityReports,
	}

	var resp interface{}
	err = jsonrequest.Post(c.Config.EskAPI+"/reportitems/", ri, &resp)
	if err != nil {
		logrus.Error("Failed ReportItem post of ", ri)
		return err
	}
	return nil
}

func LatencyReport(week time.Time) error {
	latencyReport, err := BuildLatencyReport(week)
	if err != nil {
		return err
	}

	ri := reportdata.ReportItem{
		ReportID:   "latency",
		Date:       week,
		ReportName: "latency",
		Data:       latencyReport,
	}

	var resp interface{}
	err = jsonrequest.Post(c.Config.EskAPI+"/reportitems/", ri, &resp)
	if err != nil {
		logrus.Error("Failed ReportItem post of ", ri)
		return err
	}
	return nil
}
