package config

import (
	"os"

	"github.com/BurntSushi/toml"
	"github.com/sirupsen/logrus"
)

type configuration struct {
	DynamoDBEndpoint   string `toml:"dynamodb_endpoint"`
	DynamoDBTable      string `toml:"dynamodb_table"`
	queueURL           string `toml:"queue_url"`
	catalogAPI         string `toml:"catalog_api"`
	Region             string `toml:"region"`
	SqsEndpoint        string `toml:"sqs_endpoint"`
	CatalogdbPassword  string `toml:"catalogdb_password"`
	CatalogdbEndpoint  string `toml:"catalogdb_endpoint"`
	CatalogdbUsername  string `toml:"catalogdb_username"`
	RollbarAccessToken string `toml:"rollbar_access_token"`
	RollbarEnvironment string `toml:"rollbar_environment"`
	LogLevel           string `toml:"log_level"`
	AppPort            string `toml:"app_port"`
	DebugPort          string `toml:"debug_port"`
}

var Config configuration

func init() {
	setDefaultConfig()
}

// SetDefaultConfig sets up default config with sane defults for development this are(mostly) reset be config.toml in staging and production
func setDefaultConfig() {
	Config = configuration{
		DynamoDBEndpoint:   "http://dynamodb.us-west-2.amazonaws.com",
		DynamoDBTable:      "GoracleQueryHistory",
		queueURL:           "https://sqs.us-west-2.amazonaws.com/386434559102/awseb-e-k6u4kbzfwx-stack-AWSEBWorkerQueue-1BO9NCBGGNJ63",
		catalogAPI:         "https://status-development.internal.justin.tv/api/v1",
		Region:             "us-west-2",
		SqsEndpoint:        "",
		RollbarAccessToken: "70fc3e5e49ae4f948478aac2e4751ccd",
		RollbarEnvironment: "development",
		LogLevel:           logrus.WarnLevel.String(),
		AppPort:            "",
		DebugPort:          "",
	}

}

func ParseConfig(fn string) error {
	if _, err := toml.DecodeFile(fn, &Config); err != nil {
		return err
	}
	return nil
}

func CatalogDBEndpoint() string {
	env := os.Getenv("ENVIRONMENT")
	if env == "production" {
		return "aurora-cluster-goracle.cluster-ccbb38ebbj1r.us-west-2.rds.amazonaws.com:3306"
	} else if env == "development" {
		return "aurora-cluster-goracle-dev.cluster-c0uxifsihoht.us-west-2.rds.amazonaws.com:3306"
	}
	return Config.CatalogdbEndpoint
}

func QueueURL() string {
	env := os.Getenv("ENVIRONMENT")
	if env == "production" {
		return "https://sqs.us-west-2.amazonaws.com/007917851548/echo-worker"
	} else if env == "development" {
		return "https://sqs.us-west-2.amazonaws.com/386434559102/echo-worker"
	}
	return Config.queueURL
}
