package manager

// RegisterSecretUpdateCallback registers a callback to be called when a secret
// is updated
func (m *Manager) RegisterSecretUpdateCallback(secretName string, callback func(secretName string)) (err error) {
	callbacks, ok := m.secretCallbacks[secretName]
	if !ok {
		callbacks = make([]func(string), 0, 1)
	}
	m.secretCallbacks[secretName] = append(callbacks, callback)
	return
}

func (m *Manager) triggerSecretUpdateCallbacks(secretName string) {
	callbacks, ok := m.secretCallbacks[secretName]
	if !ok {
		return
	}

	for _, cb := range callbacks {
		cb(secretName)
	}
}
